<?php
/**
 * Company job stats
 * 
 * Template displays company jobs stats
 * 
 * 
 * @author Greg Winiarski
 * @package Templates
 * @subpackage JobBoard
 * 
 */
/* @var $jobList array List of jobs to display */
/* @var $browse string One of: active; expired */
/* @var $routerIndex string */
/* @var $expiredCount int Total number of company expired jobs */
/* @var $activeCount int Total number of company active jobs */
?>

<div class="where-am-i">
    <?php wpjb_breadcrumbs($breadcrumbs) ?>
</div><!-- .where-am-i -->

<ul class="wpjb-tabs wpjb-page-company-panel">
    <li class="wpjb-tab-link <?php if($browse == "active"):?>current<?php endif; ?>">
        <a href="<?php echo wpjb_link_to("employer_panel") ?>"><?php _e("Active", "jobeleon"); ?></a> (<?php echo $total->active ?>)
    </li>
    <li class="wpjb-tab-link <?php if($browse == "pending"):?>current<?php endif; ?>">
        <a href="<?php echo wpjb_link_to("employer_panel", null, array("filter"=>"pending")) ?>"><?php _e("Pending", "jobeleon"); ?></a> (<?php echo $total->pending ?>)
    </li>
    <li class="wpjb-tab-link <?php if($browse == "expired"):?>current<?php endif; ?>">
        <a href="<?php echo wpjb_link_to("employer_panel", null, array("filter"=>"expired")) ?>"><?php _e("Expired", "jobeleon"); ?></a> (<?php echo $total->expired ?>)
    </li>
</ul>

<div id="wpjb-main" class="wpjb-page-company-panel">

    <?php wpjb_flash(); ?>



    <table class="wpjb-table">
        <tbody>
            <?php if (!empty($jobList)): foreach ($jobList as $job): ?>
                    <tr class="<?php wpjb_panel_features($job) ?> wpjb-manage-item">
                        <td class="wpjb-grid-col wpjb-col-100" style="width: 100%">
                            <div class="wpjb-manage-header">
                                <?php if($job->doScheme("job_title")): else: ?>
                                <span class="wpjb-manage-header-left wpjb-line-major wpjb-manage-title">
                                    <a href="<?php echo wpjb_link_to("job", $job) ?>"><?php esc_html_e($job->job_title) ?></a>
                                    <?php if($job->is_featured): ?>
                                    <span class="wpjb-glyphs wpjb-icon-flag" title="<?php echo esc_attr( "Featured", "jobeleon" ) ?>"></span>
                                    <?php endif; ?>

                                    <?php if($job->is_filled): ?>
                                    <span class="wpjb-glyphs wpjb-icon-user-circle" title="<?php echo esc_attr( "This position is already taken", "jobeleon") ?>"></span>
                                    <?php endif; ?>
                                </span>
                                <?php endif; ?>

                                <ul class="wpjb-manage-header-right">

                                    <?php do_action( "wpjb_sh_manage_header_right_before", $job->id, $job->post_id ) ?>

                                    <li>
                                        <span class="wpjb-glyphs wpjb-icon-clock"></span>
                                        <span class="wpjb-manage-header-right-item-text">
                                            <abbr title="<?php _e("Expiration Date") ?>">
                                                <?php if($job->job_expires_at === WPJB_MAX_DATE): ?>
                                                     <?php _e("Never", "jobeleon") ?>
                                                 <?php elseif($job->expired()): ?>
                                                     <?php _e("Expired", "jobeleon") ?>
                                                 <?php else: ?>
                                                     <?php echo esc_html(wpjb_date_display(get_option("date_format"), $job->job_expires_at)) ?>
                                                 <?php endif; ?>
                                            </abbr>
                                        </span>
                                    </li>

                                    <?php do_action( "wpjb_sh_manage_header_right_after", $job->id, $job->post_id ) ?>
                                </ul>


                            </div>


                            <div class="wpjb-manage-actions-wrap">

                                <span class="wpjb-manage-actions-left">
                                    <?php $apps = Wpjb_Model_Application::search(array("job"=>$job->id, "count_only"=>true, "filter"=>"public")) ?>

                                    <?php if($apps == 0): ?>
                                    <a href="<?php echo esc_attr( wpjb_link_to( "job_applications", null, array( "job_id"=>$job->id ) ) ) ?>" title="Applications" class="wpjb-manage-action wpjb-no-hover"><span class="wpjb-glyphs wpjb-icon-inbox"></span> <?php echo $apps ?></a>
                                    <?php else: ?>
                                    <span style="position:relative">
                                        <a href="<?php echo esc_attr( wpjb_link_to( "job_applications", null, array( "job_id"=>$job->id ) ) ) ?>" title="Applications" class="wpjb-manage-action wpjb-no-hover wpjb-motif-bg wpjb-motif-border wpjb-manage-applications">
                                            <span class="wpjb-glyphs wpjb-icon-inbox"></span> 
                                            <strong><?php echo $apps ?></strong>

                                        </a>

                                        <?php $apps_unread = Wpjb_Model_Application::search(array("job"=>$job->id, "count_only"=>true, "status"=>1)) ?>
                                        <?php if($apps_unread): ?>
                                        <span class="wpjb-notify-new wpjb-manage-applications-new" title="<?php _e( "Unread Applications", "jobeleon" ) ?>"><?php echo absint( $apps_unread ) ?></span>
                                        <?php endif; ?>
                                    </span>

                                    <?php endif; ?>

                                    <a href="<?php echo wpjb_link_to("job", $job) ?>" class="wpjb-manage-action"><span class="wpjb-glyphs wpjb-icon-eye"></span><?php _e("View", "jobeleon") ?></a>
                                    <a href="<?php echo wpjb_link_to("job_edit", $job); ?>" title="<?php _e("Edit", "jobeleon") ?>" class="wpjb-manage-action"><span class="wpjb-glyphs wpjb-icon-pencil-squared"></span><?php _e("Edit", "jobeleon") ?></a>
                                    <a href="<?php echo wpjb_link_to("job_delete", $job) ?>" title="<?php _e("Delete", "jobeleon") ?>" class="wpjb-manage-action wpjb-manage-action-delete" data-id="<?php echo get_the_ID() ?>" data-nonce="<?php echo wp_create_nonce('wpjobboard-manage-delete') ?>">
                                        <span class="wpjb-glyphs wpjb-icon-trash"></span><?php _e("Delete", "jobeleon") ?>
                                    </a>

                                    <div class="wpjb-manage-action wpjb-manage-delete-confirm">
                                        <span class="wpjb-glyphs wpjb-icon-trash-1"></span>
                                        <?php _e( "Are you sure?", "jobeleon" ) ?>
                                        <span class="animate-spin wpjb-icon-spinner wpjb-manage-action-spinner" style="display:none"></span>
                                        <a href="#" class="wpjb-manage-action-delete-yes"><?php _e( "Yes", "jobeleon" ) ?></a>
                                        <a href="#" class="wpjb-manage-action-delete-no"><?php _e( "Cancel", "jobeleon" ) ?></a>
                                    </div>

                                    <?php do_action( "wpjb_sh_manage_actions_left", $job->id, $job->post_id ) ?>
                                </span>
                                <span class="wpjb-manage-actions-right">
                                    <?php do_action( "wpjb_sh_manage_actions_right", $job->id, $job->post_id ) ?>

                                    <a href="#" class="wpjb-manage-action wpjb-manage-action-more"><span class="wpjb-glyphs wpjb-icon-menu"></span><?php _e("More", "jobeleon") ?></a>
                                </span>


                            </div>

                            <div class="wpjb-manage-actions-more">
                                <?php do_action( "wpjb_sh_manage_actions_more", $job->id, $job->post_id ) ?>

                                <a href="<?php echo wpjb_link_to("step_add", null, array("republish"=>$job->id)) ?>" class="wpjb-manage-action">
                                    <span class="wpjb-glyphs wpjb-icon-plus"></span>
                                    <?php _e("Republish", "jobeleon") ?>
                                </a>

                                <?php if($browse == "pending" && in_array(Wpjb_Model_Job::STATUS_PAYMENT, $job->status())): ?>
                                <a href="<?php echo $job->paymentUrl() ?>" class="wpjb-manage-action">
                                    <span class="wpjb-glyphs wpjb-icon-money"></span>
                                    <?php _e("Make Payment ...", "jobeleon") ?>
                                </a>
                                <?php endif; ?>

                                <?php if($job->is_filled): ?>
                                <a href="<?php echo wpjb_api_url("action/job", array("id"=>$job->id, "do"=>"unfill", "redirect_to"=>$url)) ?>" class="wpjb-manage-action">
                                    <span class="wpjb-glyphs wpjb-icon-user-circle-o"></span>
                                    <?php _e("Mark as not filled", "jobeleon") ?>
                                </a>
                                <?php else: ?>
                                <a href="<?php echo wpjb_api_url("action/job", array("id"=>$job->id, "do"=>"fill", "redirect_to"=>$url)) ?>" class="wpjb-manage-action">
                                    <span class="wpjb-glyphs wpjb-icon-user-circle"></span>
                                    <?php _e("Mark as filled", "jobeleon") ?>
                                </a>
                                <?php endif; ?>
                            </div>

                            <?php do_action( "wpjb_sh_manage_after", $job->id, $job->post_id ) ?>

                        </td>
                    </tr>
                    <?php
                endforeach;
            else :
                ?>
                <tr>
                    <td colspan="" align="center">
                        <?php _e("No job listings found.", "jobeleon"); ?>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div id="wpjb-paginate-links">
        <?php wpjb_paginate_links($url, $result->pages, $result->page) ?>
    </div>


</div>

<script type="text/javascript">

    // 
    jQuery(function(){   
        
        jQuery(".company-panel-dropdown").wpjb_menu({
            position: "right"
        });
    });

</script>
