<?php

class Jobeleon_Upgrade_Manager extends Wpjb_Upgrade_Manager {
    public function connect() {
        
	add_filter('pre_set_site_transient_update_themes', array($this, 'check'));
    }
    
    public function check($transient)
    {
        if (empty($transient->checked) && isset($transient->response[$this->plugin])) {
            return $transient;
        }

        $remote = $this->remote("version");
        
        if($remote === false || $remote->result == 0) {
            return $transient;
        }

        $obj = array();
        $obj["theme"] = $this->slug;
        $obj["new_version"] = $remote->data->version;
        $obj["url"] = "";
        $obj["package"] = self::_getUrl()."/".$this->slug."/download/?license=".wpjb_conf("license_key");
        $obj["downloads"] = $remote->data->downloads;
        
        if($remote->data->downloads < 0) {
            $obj["upgrade_notice"] = $this->_m();
        }
        
        if (version_compare($this->version, $remote->data->version, '<')) {
            $transient->response[$this->plugin] = $obj;
        }

        return $transient;
    }
}

$jobeleon_upgrade_manager = new Jobeleon_Upgrade_Manager("jobeleon", "jobeleon", "#version#", "theme");
$jobeleon_upgrade_manager->connect();