<?php

/**
 * wpjobboard_theme functions and definitions
 *
 * @package wpjobboard_theme
 */
/**
 * Set the content width based on the theme's design and stylesheet.
 */
if (!isset($content_width))
    $content_width = 640; /* pixels */

/*
 * Load Jetpack compatibility file.
 */
require( get_template_directory() . '/inc/jetpack.php' );

if (!function_exists('wpjobboard_theme_setup')) :

    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which runs
     * before the init hook. The init hook is too late for some features, such as indicating
     * support post thumbnails.
     */
    function wpjobboard_theme_setup() {

        /**
         * Custom template tags for this theme.
         */
        require( get_template_directory() . '/inc/template-tags.php' );

        /**
         * Custom functions that act independently of the theme templates
         */
        require( get_template_directory() . '/inc/extras.php' );

        /**
         * Customizer additions
         */
        require( get_template_directory() . '/inc/customizer.php' );

        /**
         * Make theme available for translation
         * Translations can be filed in the /languages/ directory
         * If you're building a theme based on wpjobboard_theme, use a find and replace
         * to change 'jobeleon' to the name of your theme in all the template files
         */
        load_theme_textdomain('jobeleon', get_template_directory() . '/languages');
        /**
         * Add default posts and comments RSS feed links to head
         */
        add_theme_support('automatic-feed-links');

        /**
         * Enable support for Post Thumbnails
         */
        add_theme_support('post-thumbnails');

        /**
         * This theme uses wp_nav_menu() in one location.
         */
        register_nav_menus(array(
            'primary' => __('Primary Menu', 'jobeleon'),
            'footer' => __('Footer', 'jobeleon')
        ));

        /**
         * Enable support for Post Formats
         */
        add_theme_support('post-formats', array('aside', 'image', 'video', 'quote', 'link'));
    }

endif; // wpjobboard_theme_setup
add_action('after_setup_theme', 'wpjobboard_theme_setup');

/**
 * Setup the WordPress core custom background feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for WordPress 3.3
 * using feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 *
 * @todo Remove the 3.3 support when WordPress 3.6 is released.
 *
 * Hooks into the after_setup_theme action.
 */
function wpjobboard_theme_register_custom_background() {
    $args = array(
        'default-color' => 'ffffff',
        'default-image' => '',
    );

    $args = apply_filters('wpjobboard_theme_custom_background_args', $args);

    if (function_exists('wp_get_theme')) {
        add_theme_support('custom-background', $args);
    } else {
        define('BACKGROUND_COLOR', $args['default-color']);
        if (!empty($args['default-image']))
            define('BACKGROUND_IMAGE', $args['default-image']);
        add_custom_background();
    }
}

add_action('after_setup_theme', 'wpjobboard_theme_register_custom_background');

/**
 * Register widgetized area and update sidebar with default widgets
 */
function wpjobboard_theme_widgets_init() {
    register_sidebar(array(
        'name' => __('Sidebar', 'jobeleon'),
        'id' => 'sidebar-1',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<div class="widget-title">',
        'after_title' => '</div>',
    ));
}

add_action('widgets_init', 'wpjobboard_theme_widgets_init');

/**
 * Handle Footer Links
 */
function jobeleon_footer_links() {
    $option = get_option( "jobeleon_footer_links" );
    
    if(!is_array($option)) {
        $prefix = array("Super", "Secure");
        $p = $prefix[rand(0, count($prefix)-1)];
        $option = array(
            "anchor" => sprintf( "%s Applicant Tracking System - WPJobBoard", $p),
            "check" => 0,
            "link" => 1
        );
    }
    
    $option = apply_filters( "jobeleon_footer_links", $option );
    
    if($option["link"]) {
        echo sprintf( '<p>Powered by <a href="https://wordpress.org/">WordPress</a> and <a href="https://wpjobboard.net/" target="_blank">%s</a></p>', esc_html($option["anchor"]) );
    }
}


/**
 * Enqueue scripts and styles
 */
function wpjobboard_theme_scripts() {
    
    //if(is_wpjb() && wpjb_is_routed_to("index.index")) wp_dequeue_script( 'wpjb-js' );
    wp_dequeue_style( 'wpjb-css' );
    wp_enqueue_style( 'wpjb-glyphs' );
    
    wp_enqueue_style('wpjobboard_theme-style', get_stylesheet_uri());

    wp_enqueue_script('wpjobboard_theme-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true);

    wp_enqueue_script('wpjobboard_theme-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    if (is_singular() && wp_attachment_is_image()) {
        wp_enqueue_script('wpjobboard_theme-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array('jquery'), '20120202');
    }

    // add input placeholder for... y'know... stuff...
    wp_enqueue_script('wpjobboard_theme_placeholder', get_template_directory_uri() . '/js/jquery-placeholder/jquery.placeholder.min.js', array('jquery'), '20130105');

    wp_enqueue_script('wpjobboard_theme_customSelect', get_template_directory_uri() . '/js/jquery.customSelect.min.js', array('jquery'), '20130905');

    wp_enqueue_script('wpjobboard_theme_scripts', get_template_directory_uri() . '/js/wpjobboard_theme_scripts.js', array('jquery'), '20130427');


    wp_register_script('wpjobboard_theme_live_search', get_template_directory_uri() . '/js/wpjobboard_theme_live_search.js', array('jquery'), '2');
    wp_localize_script('wpjobboard_theme_live_search', 'WpjbLiveSearchLocale', array(
        "no_jobs_found" => __('No job listings found', 'jobeleon'),
        "no_resumes_found" => __('No resumes found', 'jobeleon'),
        "load_x_more" => __('Load %d more', 'jobeleon')
    ));
    
}

add_action('wp_enqueue_scripts', 'wpjobboard_theme_scripts', 30);

/**
 * Implement the Custom Header feature
 */
//require( get_template_directory() . '/inc/custom-header.php' );
// we need to set default background color not for customizer but the subpage in appearance
add_theme_support('custom-background', array('default-color' => 'eff0f2'));

if (!function_exists('logme')) {

    function logme($message) {
        if (WP_DEBUG === true) {
            if (is_array($message) || is_object($message)) {
                error_log(print_r($message, true));
            } else {
                error_log($message);
            }
        }
    }

}
add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10);
add_filter('image_send_to_editor', 'remove_thumbnail_dimensions', 10);

function remove_thumbnail_dimensions($html) {
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}

add_action('wp_print_styles', 'wpjobboard_theme_deregister', 100);

function wpjobboard_theme_deregister() {
    wp_deregister_style('wpjb-css');
}

function wpjobboard_theme_render_step($num, $mark = "<strong>&raquo; {text}</strong>", $currentStep = null) {
    $steps = array(
        array(esc_html(Wpjb_Project::getInstance()->conf("seo_step_1")), __("Create ad", "jobeleon")),
        array(esc_html(Wpjb_Project::getInstance()->conf("seo_step_2")), __("Preview", "jobeleon")),
        array(esc_html(Wpjb_Project::getInstance()->conf("seo_step_3")), __("Done!", "jobeleon"))
    );

    $current = $steps[($num - 1)];
    if (strlen($current[0]) == 0) {
        $current = $current[1];
    } else {
        $current = $current[0];
    }

    if($currentStep === null && function_exists("wpjb_view")) {
        $currentStep = wpjb_view("current_step");
    }

    if ($currentStep == $num) {
        $title = str_replace("{text}", $current, $mark);
        echo '<li class="wpjb-current-step">';
        echo $num . '. ' . $title;
        echo '</li>';
        Wpjb_Project::getInstance()->title = $current;
    } else {
        echo '<li ' . ( $num < $currentStep ? 'class="wpjb-begone-step"' : '' ) . '>';
        echo $num . '. ' . $current;
        echo '</li>';
    }
}

function wpjobboard_theme_block_resume_details() {
    $basedir = basename(Wpjb_Project::getInstance()->getBaseDir());

    $suffix = 'green'; // color scheme
    $color_scheme = get_theme_mod('wpjobboard_theme_color_scheme');
    $suffix = !empty($color_scheme) ? $color_scheme : $suffix;

    $img = new Daq_Helper_Html("span", array(
        "class" => "wpjb-glyphs wpjb-icon-lock jobeleon-darken-color",
        "style" => "margin-left:0px"
    ));
    $img->forceLongClosing(true);

    $m = $img->render() . " ";
    $m .= '<i>' . __("Locked", 'jobeleon') . '</i>';

    return $m;
}

function wpjobboard_theme_admin_style() {
    wp_enqueue_style('wpjobboard_theme_admin_style', get_template_directory_uri() . '/stylesheets/admin.css');
}

add_action('admin_init', 'wpjobboard_theme_admin_style');

function wpjobboard_theme_color_scheme() {

    $img_directory = get_template_directory_uri() . '/stylesheets/img/';

    $color_scheme = get_theme_mod('wpjobboard_theme_color_scheme');
    // default
    if ('green' == $color_scheme) {
        return;
    }
    switch ($color_scheme) {
        case 'blue':
            $normal_color = '#5cace2';
            $darken_color = '#59a7db';
            $lighten_color = '#5eb2ea';
            break;
        case 'mint':
            $normal_color = '#3abd8f';
            $darken_color = '#38b78b';
            $lighten_color = '#40ce9c';
            break;
        case 'red':
            $normal_color = '#e74c3c';
            $darken_color = '#e04a3a';
            $lighten_color = '#f05748';
            break;
        default: return;
    }
    
    extract( apply_filters('jobeleon_color_scheme', compact( $normal_color, $darken_color ) ) );
    
// map tooltip setting is on job.php
    echo '<style>';
    echo "
.jobeleon-normal-color {
    color: $normal_color;
}
.jobeleon-normal-bg, .noUi-connect {
    background-color: $normal_color;
}
.jobeleon-normal-border {
    border-color: $normal_color;
}
.jobeleon-darken-color {
    color: $darken_color;
}
.jobeleon-darken-bg {
    background-color: $darken_color;
}
.jobeleon-darken-border {
    border-color: $darken_color;
}


::selection {
        background: $normal_color;
}
::-moz-selection {
        background: $normal_color;
}
a,
.widget li a:hover,
.wpjb-element-input-radio .wpjb-field,
.widget .recentcomments a,
.comment-list .edit-link a        {
        color: $normal_color;
}
.btn,
.widget input[type=\"submit\"],
body:after,
input[type=\"submit\"],
input[type=\"reset\"],
button,
.wpjb-button,
#wpjb-step .wpjb-current-step:before,
#wpjb-step .wpjb-begone-step:before,
.wpjb-filters .wpjb-sub-filters,
.wpjb-filters .wpjb-top-filter > a,
#wpjb-step:after,
.page-numbers a,
.comment-list .reply a,
#wpjb-paginate-links .page-numbers,
.customSelectInner:after, 
.wpjb-new-btn:hover,
.wpjb-dropdown
{
        background-color: $normal_color;
}
.btn:hover,
.widget input[type=\"submit\"]:hover,
input[type=\"submit\"]:hover,
input[type=\"reset\"]:hover,
button:hover,
.wpjb-button:hover,
.page-numbers a:hover,
.comment-list .reply a:hover,
#wpjb-paginate-links .page-numbers:hover
{
        background-color: $darken_color;
}
.wpjb-element-input-radio .wpjb-field input:checked
{
        border-color: $normal_color;
}
.wpjb-filters .wpjb-top-filter > a:after {
        border-left-color: $normal_color;
}
.wpjb-box { background-color: $normal_color; }
.wpjb-box:hover { background-color: $darken_color; }
.wpjb .blue span { background-color: $normal_color; }
    
.wpjb .wpjb-motif { color: $normal_color; }
.wpjb .wpjb-motif-bg { background-color: $normal_color; }
.wpjb .wpjb-motif-border { border-color: $normal_color; }
.wpjb .wpjb-motif-border-top { border-top-color: $normal_color; }
.wpjb .wpjb-motif-border-right { border-right-color: $normal_color }
.wpjb .wpjb-motif-border-bottom { border-bottom-color: $normal_color; }
.wpjb .wpjb-motif-border-left { border-left-color: $normal_color; }


";
    echo '</style>';
}

add_action('wp_head', 'wpjobboard_theme_color_scheme');


// 4.3 functions

global $wpjobboard;

function jobeleon_is_wpjb($content = null) {
    global $post;
    
    if($content == null && $post) {
        $content = $post->post_content;
    }
    
    if(!function_exists("is_wpjb")) {
        return false;
    }
    
    if(is_wpjb() || is_wpjr()) {
        return true;
    }
    
    $valid = array("wpjb_alerts", "wpjb_apply_form", "wpjb_jobs_add", "wpjb_jobs_list", "wpjb_jobs_search", "wpjb_employer_panel",
        "wpjb_employers_list", "wpjb_employers_search", "wpjb_resumes_list", "wpjb_resumes_search", "wpjb_employer_register",
        "wpjb_candidate_register", "wpjb_candidate_panel"
    );
    foreach($valid as $sh) {
        if(has_shortcode($content, $sh)) {
            return true;
        }
    }
    
    return false;
}

add_action("init", "jobeleon_init");
function jobeleon_init() {
        
    wp_register_style( 'jobeleon-nouislider', get_template_directory_uri()."/stylesheets/jquery.nouislider.min.css" );
    wp_register_style( 'jobeleon-nouislider-pips', get_template_directory_uri()."/stylesheets/jquery.nouislider.pips.min.css" );
    
    wp_register_script( 'jobeleon-nouislider', get_template_directory_uri().'/js/jquery.nouislider.all.js', array("jquery"));
    
    
}

add_filter( "jobeleon_footer_links", "jobeleon_check_links" );
function jobeleon_check_links( $option ) {
    
    $force_check = isset( $_REQUEST["jobeleon-footer-check"] );
    
    if($force_check || $option["check"] < time() - 3600 * 24 * 7) {
        
        $response = wp_remote_get( "http://api.wpjobboard.net/link/" );
        if( ! is_wp_error( $response ) ) {
            $option["link"] = intval($response["body"]);
        }
        
        $option["check"] = time();
        update_option( "jobeleon_footer_links", $option );
    }
    
    return $option;
}



if(is_admin()) {
    add_action( "init", "jobeleon_upgrade_manager_init");
    include_once dirname(__FILE__) . '/inc/admin-pages.php'; 
}

function jobeleon_upgrade_manager_init() {
    
    if(class_exists("Wpjb_Project") && is_admin()) {
        include_once dirname(__FILE__) . '/inc/class-upgrade-manager.php';
    }
}

if(!function_exists("wpjb_view")) {
    function wpjb_view($param, $default = null) {
        if($param == "job") {
            if(!is_singular("job")) {
                $form = new Wpjb_Form_AddJob();
                $id = "wpjb_session_".str_replace("-", "_", wpjb_transient_id());
                $transient = wpjb_session()->get($id);
                $jobArr = $transient["job"];
                $form->isValid($jobArr);

                return $form->buildModel();
            } else {
                return wpjb_get_object_from_post_id(get_the_ID(), "job");
            }
        } else if($param == "current_step") {
            if(wpjb_is_routed_to("step_preview")) {
                return 2;
            } else if(wpjb_is_routed_to("step_save")) {
                return 3;
            } else {
                return 1;
            }
        } else {
            return null;
        }
    }
}

if(!function_exists("wpjb_add_job_steps")) {
    function wpjb_add_job_steps() {
        $view = new Wpjb_Shortcode_Dynamic();
        echo $view->render("job-board", "step");
    }
}

if(!function_exists("wpjb_job_template")) {
    function wpjb_job_template() {
        $view = new Wpjb_Shortcode_Dynamic();
        $view->view = new stdClass();

        echo $view->render("job-board", "job");
    }
}

if(!function_exists("wpjb_job_created_at")) {
    function wpjb_job_created_at($date_format, $job) {
        return wpjb_date_display($date_format, $job->job_created_at);
    }
}

/* LJM increasing related jobs to 20 from 5*/
add_filter( "wpjb_jobs_related", "my_wpjb_jobs_related" );
function my_wpjb_jobs_related( $params ) {
$params["count"] = 20;
return $params;
}

/* LJM allowing tables in job content */
add_filter("wpjb_rich_text_kses_allowed_html", "my_wpjb_rich_text_kses_allowed_html");
function my_wpjb_rich_text_kses_allowed_html($allowed) {
    $allowed["a"]["target"] = true;
    $allowed["table"] = true;
    $allowed["tbody"] = true;
    $allowed["tr"] = array( "colspan" => true, "rowspan" => true );
	$allowed["td"] = array( "colspan" => true, "rowspan" => true );
    $allowed["th"] = true;
    return $allowed;
}
/* replacing This
$allowed["tr"] = true;
$allowed["td"] = true;

with this
$allowed["tr"] = array( "colspan" => true, "rowspan" => true );
$allowed["td"] = array( "colspan" => true, "rowspan" => true );

*/


//LJM 
/* Remove Yoast SEO Canonical From Search Pages Only
 * Credit: Yoast Team
 * Last Tested: Jun 16 2017 using Yoast SEO 4.9 on WordPress 4.8
 */
/*
add_filter( 'wpseo_canonical', 'yoast_remove_canonical_search' );
function yoast_remove_canonical_search( $canonical ) {
	if( is_search() ) {
		return false;
	} else {
		return $canonical;
	}
}
*/

//LJM I've removed this because canonical is actually useful... added it back because canon blocks categroy pages from being indexed
/* Remove Yoast SEO Canonical From All Pages
 * Credit: Yoast Team
 * Last Tested: Jun 16 2017 using Yoast SEO 4.9 on WordPress 4.8
 */

//Before removing canonical and after
//
//add_filter( 'wpseo_canonical', '__return_false' );
//Keyword: latest jobs in uganda
//Position: 38 before was 32
//URL: https://everjobs.ug/

//Keyword: latest UGANDA JOBS
//Position: 76 before was 30
//URL: https://everjobs.ug/
//


/* LJM setting default country selection as Tanzania */
add_filter("wpjb_locale", "my_wpjb_locale");
function my_wpjb_locale($locale) {
  return 834;
}

/* LJM copied from https://gist.github.com/amboutwe/550c10ede7d065d9264930f5480ca748#file-yoast_seo_title_custom-variable-php */
/* Remove Yoast SEO Add custom title or meta template variables
 * Credit: Moshe Harush
 * https://stackoverflow.com/questions/36281915/yoast-seo-how-to-create-custom-variables
 * Last Tested: Nov 29 2018 using Yoast SEO 9.2.1 on WordPress 4.9.8
 *******
 * NOTE: The snippet preview in the backend will show the custom variable '%%myname%%'.
 * However, the source code of your site will show the output of the variable 'My name is Moses'.
 */
// define the custom replacement callback
function get_myname() {
    return 'Yo Jobs';
}
// define the action for register yoast_variable replacments
function register_custom_yoast_variables() {
    wpseo_register_var_replacement( '%%myname%%', 'get_myname', 'advanced', 'some help text' );
}
// Add action
add_action('wpseo_register_extra_replacements', 'register_custom_yoast_variables');


// LJM author's solution
//
//
/*
add_action("wpseo_title", "my_wpseo_title");

add_action("wpseo_metadesc", "my_wpseo_title");

function my_wpseo_title( $desc ) {
    if( is_singular('job') ) {
        $job = wpjb_get_object_from_post_id(get_the_ID(), "job");
		
		if (!empty($job->getTag()->category)) {
			
			foreach ($job->getTag()->category as $category) {
				
				$my_category_title = $category->title ;
				
			}
		} else {
			
			$my_category_title = "no";
		}
		
        $find = array( "{apply_instructions}", "{company_name}", "{job_category}" );
        $repl = array( $job->meta->apply_instructions->value(), $job->company_name, $my_category_title );
        return str_replace( $find, $repl, $desc );
    } else {
        return $desc;
    }
}

*/

//LJM
// custom tags for yoast job page

add_action("wpseo_title", "my_wpseo_title");

add_action("wpseo_metadesc", "my_wpseo_title");

function my_wpseo_title( $desc ) {
	
    if( is_singular('job') ) {
		
        $job = wpjb_get_object_from_post_id(get_the_ID(), "job");
		
		if (!empty($job->getTag()->category)) {
			
			$category = $job->getTag()->category[0];
				
			$my_category_title = $category->title;
				
			} else {
			
			$my_category_title = "";
			
			}
		
		if (!empty($job->getTag()->type)) {
			
			$type = $job->getTag()->type[0];
			
			$type_name = $type->title;
		
		} else {
			
			$type_name = "";
			
		}
		
        $find = array( "{apply_instructions}", "{company_name}", "{job_category}", "{job_city}", "{job_type}" );
        $repl = array( $job->meta->apply_instructions->value(), $job->company_name, $my_category_title, $job->job_city, $type_name );
        return str_replace( $find, $repl, $desc );
    } else {
        return $desc;
    }
	
}

// LJM 
// by Greg 
// making homepage to show search query and category as the seo title, 
//TODO: Capitalize this search query
/* working well - last removed.
add_filter( "wpseo_title", function( $title ) {
    $request = Daq_Request::getInstance();
    $form = new Wpjb_Form_AdvancedSearch(null);
    $form->isValid($request->get());
    $rQuery = wpjb_readable_query($request->get(), $form, new Wpjb_Form_AddJob());
//    if( ! isset( $rQuery["show_results"] ) ) {
	  if( ! is_page( 13 ) ) {
        return $title;
    }
    if( isset( $rQuery["query"]["value"][0] ) ) {
        $keyword = $rQuery["query"]["value"][0];
    } else {
        $keyword = "";
    }
	
	if( isset( $rQuery["category"]["value"] ) ) {
	$category_title = join( ", ", $rQuery["category"]["value"] );
	} else {
	$category_title = "";
	}
	
	return sprintf( "%s Jobs in Tanzania, New %s Jobs, Tanzania %s Vacancies and Employment", $keyword, $category_title,  $keyword );
} );
*/

/* first removed - also probably working
add_filter( "wpseo_title", function( $title ) {
    $request = Daq_Request::getInstance();
    $form = new Wpjb_Form_AdvancedSearch(null);
    $form->isValid($request->get());
    $rQuery = wpjb_readable_query($request->get(), $form, new Wpjb_Form_AddJob());
    if( ! isset( $rQuery["show_results"] ) ) {
        return $title;
    }
    if( isset( $rQuery["query"]["value"][0] ) ) {
        $keyword = $rQuery["query"]["value"][0];
    } else {
        $keyword = "All";
    }
    if( isset( $rQuery["location"]["value"][0] ) ) {
        $location = $rQuery["location"]["value"][0];
    } else {
        $location = "anywhere";
    }
    return sprintf( "%s Jobs in %s", $keyword, $location );
} );
*/

//Setting custom meta titles in yoast
// removing this to use custome pages instead...

add_filter( "wpseo_title", function( $title ) {
    $request = Daq_Request::getInstance();
    $form = new Wpjb_Form_AdvancedSearch(null);
    $form->isValid($request->get());
    $rQuery = wpjb_readable_query($request->get(), $form, new Wpjb_Form_AddJob());

    $ids = array( wpjb_conf( "urls_link_job" ), wpjb_conf( "urls_link_job_search" ) );

    if( ! is_page( $ids[0] ) && ! is_page( $ids[1] ) ) {
        return $title;
    }
    if( isset( $rQuery["query"]["value"][0] ) ) {
        $keyword = $rQuery["query"]["value"][0];
		$keyword_uppercase = ucfirst($keyword);
    } else {
        
		$keyword_uppercase = "Nokey";
    } 

    if( isset( $rQuery["category"]["value"] ) ) {
        $category_title = join( ", ", $rQuery["category"]["value"] );
    } else if ( get_query_var("wpjb-tag") == "category" ) {
        $query = new Daq_Db_Query;
        $query->from("Wpjb_Model_Tag t");
        $query->where("slug = ?", get_query_var("wpjb-slug"));
        $query->where("type = ?", get_query_var("wpjb-tag"));
        $query->limit(1);

        $result = $query->execute();
        $model = $result[0];
        $category_title = $result[0]->title;
    } else {
        $category_title = "Nocat";
    }  
    
    if( isset( $rQuery["location"]["value"][0] ) ) {
        $location = $rQuery["location"]["value"][0];
        $location_up = ucfirst($location);
    } else {
        $location_up = "Tanzania";
    }
    
        
        

	//TODO: CREATE HERE CONDITION THAT DISPLAYS DIFFERENT TITLE TEMPLATE FOR Category only, Search Only, AND HOMEPAGE. WITH HOMEPAGE 
	//AS DEFAULT.or last
	// use else ifs.
	// Then also capitalize the first letter of the search query
	// Better with Job count 
	// also can add the current month e.g August 2019
    //return sprintf( "%s Jobs in %s", $keyword, $category_title );
    //
    //
    
	if  ( ( $keyword_uppercase == "Nokey" ) && ($category_title == "Nocat") ) { //shows when we have no keyword and no category, like on home page 
		
		//return sprintf( "Jobs in %s - Latest Tanzania Jobs, Vacancies & Careers - NewJobs", $location_up );
		
		return $title;
		
	} else if ( ( $keyword_uppercase != "Nokey" ) && ($category_title == "Nocat") ) { // here we have a keyword search BUT no category, just a basic search
		
		return sprintf( "%s Jobs in %s - New Jobs & Vacancies Daily - NewJobs", $keyword_uppercase, $location_up );
		
	} else if ( ( $keyword_uppercase == "Nokey" ) && ($category_title != "Nocat") ) { // here we have NO keyword search but a category selected, just like category pages
		
		return sprintf( "%s Jobs in %s - %s Vacancies & Careers - NewJobs", $category_title, $location_up, $category_title );
		
	}  else if ( ( $keyword_uppercase != "Nokey" ) && ($category_title != "Nocat") ) { // here we have BOTH keyword search AND category selected - this has failed so we pushed it to else 
		
	return sprintf( "%s Jobs in Tanzania, %s Tanzania Jobs, %s Vacancies and Employment Offers Theres BOTH ", $keyword_uppercase, $category_title );
		
	}  else { // everything else - JUST use a good title to catch all - its working for both category and keyword, plus location if available
		
		return sprintf( "%s Jobs in %s - %s Jobs & Careers - NewJobs ", $keyword_uppercase, $location_up, $category_title );
		
	}
		
	
} );



//Setting custom meta DESCRIPTIONS in yoast

add_filter( "wpseo_metadesc", function( $desc ) {
    $request = Daq_Request::getInstance();
    $form = new Wpjb_Form_AdvancedSearch(null);
    $form->isValid($request->get());
    $rQuery = wpjb_readable_query($request->get(), $form, new Wpjb_Form_AddJob());

    $ids = array( wpjb_conf( "urls_link_job" ), wpjb_conf( "urls_link_job_search" ) );

    if( ! is_page( $ids[0] ) && ! is_page( $ids[1] ) ) {
        return $desc;
    }
    if( isset( $rQuery["query"]["value"][0] ) ) {
        $keyword = $rQuery["query"]["value"][0];
		$keyword_uppercase = ucfirst($keyword);
    } else {
        
		$keyword_uppercase = "Nokey";
    } 

    if( isset( $rQuery["category"]["value"] ) ) {
        $category_title = join( ", ", $rQuery["category"]["value"] );
    } else if ( get_query_var("wpjb-tag") == "category" ) {
        $query = new Daq_Db_Query;
        $query->from("Wpjb_Model_Tag t");
        $query->where("slug = ?", get_query_var("wpjb-slug"));
        $query->where("type = ?", get_query_var("wpjb-tag"));
        $query->limit(1);

        $result = $query->execute();
        $model = $result[0];
        $category_title = $result[0]->title;
    } else {
        $category_title = "Nocat";
    }  
    
    
    if( isset( $rQuery["location"]["value"][0] ) ) {
        $location = $rQuery["location"]["value"][0];
        $location_up = ucfirst($location);
    } else {
        $location_up = "Tanzania";
    }
    
	//TODO: CREATE HERE CONDITION THAT DISPLAYS DIFFERENT TITLE TEMPLATE FOR Category only, Search Only, AND HOMEPAGE. WITH HOMEPAGE 
	//AS DEFAULT.or last
	// use else ifs.
	// Then also capitalize the first letter of the search query
	// Better with Job count 
	// also can add the current month e.g August 2019
    //return sprintf( "%s Jobs in %s", $keyword, $category_title );
    //
    //
    
	if  ( ( $keyword_uppercase == "Nokey" ) && ($category_title == "Nocat") ) { //shows when we have no keyword and no category, like on home page 
		
		// return sprintf( "Tanzania Jobs - See the latest jobs in %s, vacancies and career opportunities. Updated daily with new job offers for you", $location_up );
		
		return $desc;
		
	} else if ( ( $keyword_uppercase != "Nokey" ) && ($category_title == "Nocat") ) { // here we have a keyword search BUT no category, just a basic search 
		
		return sprintf( "Tanzania Jobs - Find %s Jobs in %s. The latest %s Jobs, Vacancies and Offers available", $keyword_uppercase, $location_up, $keyword_uppercase );
		
	} else if ( ( $keyword_uppercase == "Nokey" ) && ($category_title != "Nocat") ) { // here we have NO keyword search but a category selected, just like category pages 
		
		return sprintf( "Tanzania Jobs : %s Jobs available in %s. Daily updates for recent %s career opportunities - NewJobs", $category_title, $location_up, $category_title );
		
	}  else if ( ( $keyword_uppercase != "Nokey" ) && ($category_title != "Nocat") ) { // here we have BOTH keyword search AND category selected - this has failed so we pushed it to else 
		
		return sprintf( "%s Jobs in Tanzania, %s TZ Jobs, %s Vacancies and Employment Offers Theres BOTH ", $keyword_uppercase, $category_title );
		
	}  else { // everything else - JUST use a good title to catch all
		
		
		return sprintf( "%s Jobs in %s - Check All %s Jobs, Vacancies and Offers. Updated every day - NewJobs Tanzania", $keyword_uppercase, $location_up, $category_title );
		
		
	}
		
	
} ); 