<?php

/**
* Form for WPLM Config
* 
* @since 1.0
* @access public
*/
class Wpjobboard_Si_Config_Form extends Daq_Form_Abstract {
    
    public $name = null;
    
    
    public function init()
    {
        $this->name = __( "Sliced Invoices Configuration", "wpjb-si" );
                
        $this->addGroup( "employer", __( "Invoice Employer Client Mapping", "wpjb-wpml" ) );
        //$this->addGroup( "candidate", __( "Invoice Candidate Client Mapping", "wpjb-wpml" ) );
        
        $company_form = new Wpjb_Form_Frontend_Company();
        //$company_options = array( array( 'key' => 0, 'value' => 0, 'description' => "" ) );
        foreach($company_form->getFields() as $field) {
            $company_options[] = array( 'key' => 'company__'.$field->getName(), 'value' => 'company__'.$field->getName(), 'description' => __("Company - ", "wpjobboard-si") . $field->getLabel() );
        }
        
        $job_form = new Wpjb_Form_AddJob();
        foreach($job_form->getFields() as $field) {
            $company_options[] = array( 'key' => 'job__'.$field->getName(), 'value' => 'job__'.$field->getName(), 'description' => __("Job - ", "wpjobboard-si") . $field->getLabel() );
        }
        
        $sliced_conf_url = admin_url( 'admin.php?page=sliced_business' );
        $wpjb_doc_url = 'https://wpjobboard.net/kb/sliced-invoices-integration/';
        
        $e = new Daq_Form_Element_Label('wpjb_si_info');
        $e->setLabel( __( "Instructions", "wpjb-si") );
        $e->setHint( __( '<p style="font-size:12px">In the form below you can select which Job or Company data to automatically use on the invoice generated for the client. All fields are optional, and the user will be able to change the billing data in the checkout before making payment.</p><p style="font-size:12px">Remember to provide your company information in <a href="'.$sliced_conf_url.'">Sliced Invoices Configuration</a>.</p><p style="font-size:12px">If you need any additional assistance, please check our <a href="'.$wpjb_doc_url.'" target="_blank">documentation</a>.</p> ', "wpjb-si") );
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_client_name');
        $e->setLabel( __( "Business Name", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_client_name') );
        $e->addOption(0, 0, "");
        $e->addOption( 'full_name', 'full_name', "Full name");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_country');
        $e->setLabel( __( "Address: Country", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_country') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_state');
        $e->setLabel( __( "Address: State", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_state') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_zip_code');
        $e->setLabel( __( "Address: Zip Code", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_zip_code') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_city');
        $e->setLabel( __( "Address: City", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_city') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_address');
        $e->setLabel( __( "Address: Street Address", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_address') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_ai_tax_id');
        $e->setLabel( __( "Tax ID", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_ai_tax_id') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        $e = new Daq_Form_Element_Select('wpjb_si_emp_ai_phone');
        $e->setLabel( __( "Company Phone", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_emp_ai_phone') );
        $e->addOption(0, 0, "");
        $e->addOptions($company_options);
        $this->addElement($e, "employer");
        
        /*$candidate_form = new Wpjb_Form_Resume();
        $candidate_options = array( array( 'key' => 0, 'value' => 0, 'description' => "" ) );
        foreach($candidate_form->getFields() as $field) {
            $candidate_options[] = array( 'key' => $field->getName(), 'value' => $field->getName(), 'description' => $field->getLabel() );
        }
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_client_name');
        $e->setLabel( __( "Business/Client Name", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_client_name') );
        $e->addOption(0, 0, "");
        $e->addOption( 'full_name', 'full_name', "Full name");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_country');
        $e->setLabel( __( "Client Address: Country", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_country') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_state');
        $e->setLabel( __( "Client Address: State", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_state') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_zip_code');
        $e->setLabel( __( "Client Address: Zip-Code", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_zip_code') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_city');
        $e->setLabel( __( "Client Address: City", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_city') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_address');
        $e->setLabel( __( "Client Address: Address", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_address') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_ai_tax_id');
        $e->setLabel( __( "Tax ID", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_ai_tax_id') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate");
        
        $e = new Daq_Form_Element_Select('wpjb_si_cand_ai_phone');
        $e->setLabel( __( "Candidate Phone", "wpjb-si") );
        $e->setValue( wpjb_conf('wpjb_si_cand_ai_phone') );
        $e->addOption(0, 0, "");
        $e->addOptions($candidate_options);
        $this->addElement($e, "candidate"); */
        
    }

}