<?php
class Wpjobboard_Si_Admin
{
    
    /**
     * Object contructor
     * 
     * Protected constructor allows to create only one instance of this class.
     * 
     * @since 1.0
     * @return Wpjobboard_Si_Admin
     */
    public function __construct() {
        
        add_action( "init", array( $this, "init" ));
        add_action( "plugins_loaded", array( $this, "updates_manager" ) );
    }
    
    /**
     * General Init Function
     * 
     * This function is executed in both frontend and wp-admin
     * 
     * @since 1.0
     * @return void
     */
    public function init() {
        
        add_filter( "wpjb_config_sections", array( &$this, "wpjb_config_sections" ) );
    }

    
    function wpjb_config_sections($config) {
        
        include_once Wpjobboard_Si::get_instance()->get_basedir() . "/includes/class-wpjobboard-si-form.php";
        
        foreach($config as $i => $section) {
            if($section['title'] == 'Integrations') {
                $config[$i]['item'][] = array(
                    "form"  => "slicedinvoices",
                    "class" => "Wpjobboard_Si_Config_Form",
                    //"image" => Wpjb_Wpml::get_instance()->get_baseurl() . "assets/images/wpml_logo.png",
                    "icon"  => "wpjb-icon-chart-pie",
                    "title" => __("Sliced Invoices", "wpjobboard"),
                    "order" => 8
                );
                
                break;
            }
        }
        
        return $config;
    }

    /**
     * Sliced Invoices Integration Updates Manager
     *
     * This functions is executed by plugins_loaded action
     *
     * @since 1.1
     * @return void
     */
    public function updates_manager() {

        if(!defined("Wpjb_Upgrade_Manager::MULTI")) {
            // old WPJB version without add-ons automatic updates support
            return;
        }

        $manager = new Wpjb_Upgrade_Manager(
            "wpjobboard-sliced-invoices/wpjobboard-si.php", 
            "wpjobboard-sliced-invoices", 
            "1.0.0"
        );
        $manager->connect();

        Wpjb_Project::getInstance()->env("upgrade")->{'wpjobboard-sliced-invoices'} = $manager;
    }

}
