<?php

/**
* Form for Broadbean Config
* 
* @since 1.0
* @access public
*/
class Wpjobboard_Mailchimp_Config_Form extends Daq_Form_Abstract {
    
    public $name = null;
    
    
    public function init()
    {       
        $this->name = __( "MailChimp Configuration", "wpjobboard-mc" );
        
        $this->addGroup( "default", __( "MailChimp API", "wpjobboard-mc" ) );
        $this->addGroup( "lists", __( "MailChimp Lists", "wpjobboard-mc" ) );
        $this->addGroup( "debugger", __( "Debugger", "wpjobboard-mc" ) );
        
        $e = new Daq_Form_Element_Label('get_api');
        $e->setHint( 'Instruction how to get your API key: <a href="https://kb.mailchimp.com/integrations/api-integrations/about-api-keys#Find-or-Generate-Your-API-Key">https://kb.mailchimp.com/integrations/api-integrations/about-api-keys#Find-or-Generate-Your-API-Key</a>' );
        $this->addElement( $e, "default" );
        
        $e = new Daq_Form_Element_Text('mailchimp_api_key');
        $e->setLabel( __( "MailChimp API Key", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "mailchimp_api_key" ) );
        $this->addElement( $e, "default" );
        
        
        $e = new Daq_Form_Element_Label('get_list');
        $e->setHint( 'Instruction how to get your list ID: <a href="https://kb.mailchimp.com/lists/manage-contacts/find-your-list-id">https://kb.mailchimp.com/lists/manage-contacts/find-your-list-id</a>' );
        $this->addElement( $e, "lists" );
        
        $e = new Daq_Form_Element_Text('mailchimp_employer_list');
        $e->setLabel( __( "Employer List ID", "wpjobboard-mc" ) );
        $e->setHint( __( "Leave blank if you do not want to add Employers to list.", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "mailchimp_employer_list" ) );
        $this->addElement( $e, "lists" );
        
        $e = new Daq_Form_Element_Text('mailchimp_candidate_list');
        $e->setLabel( __( "Candidate List ID", "wpjobboard-mc" ) );
        $e->setHint( __( "Leave blank if you do not want to add Candidates to list.", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "mailchimp_candidate_list" ) );
        $this->addElement( $e, "lists" );
        
        $e = new Daq_Form_Element_Text( 'refresh' );
        $e->setLabel( __( "Add Current Users", "wpjobboard-mc" ) );
        //$e->setHint( __( "Add current users to proper lists.", "wpjobboard-mc" ) );
        $e->setRenderer( array( &$this, 'render_refresh' ) );
        $this->addElement( $e, "debugger" );
        
    }
    
    function render_refresh() {

        ob_start();
            include_once Wpjobboard_Mailchimp::get_instance()->get_basedir() . '/templates/debug.php';
        ob_flush();
    }
}