<?php

class Wpjobboard_Ga 
{
    /**
     * Wpjobboard_Ga Singleton
     * 
     * @var Wpjobboard_Ga
     */
    protected static $_instance = null;
    
    /**
     * Path to wpjobboard-ga (eg. /public_html/wp-content/plugins/wpjobboard-ga)
     *
     * @var string
     */
    protected $_basedir = null;
    
    /**
     * URL to wpjobboard-ga (eg. http://example.com/wp-content/plugins/wpjobboard-ga)
     *
     * @var string
     */
    protected $_baseurl = null;
    
    /**
     * Admin Object
     *
     * @var Wpjobboard_Ga_Admin
     */
    public $admin = null;
    
    /**
     * Ajax Object
     *
     * @var Wpjobboard_Ga_Ajax
     */
    public $ajax = null;
    
    /**
     * Frontend Object
     *
     * @var Wpjobboard_Frontend_Admin
     */
    public $frontend = null;
    
    /**
     * Object contructor
     * 
     * Protected constructor allows to create only one instance of this class.
     * 
     * @since 1.0
     * @return Wpjobboard_Ga
     */
    protected function __construct() {
        
        $this->_basedir = dirname( dirname( __FILE__ ) );
        $this->_baseurl = plugin_dir_url( dirname( __FILE__ ) );
        
        if( is_admin() ) {
            include_once $this->_basedir . "/includes/class-wpjobboard-ga-admin.php";
            include_once $this->_basedir . "/includes/class-wpjobboard-ga-ajax.php";
            $this->admin = new Wpjobboard_Ga_Admin();
            $this->ajax = new Wpjobboard_Ga_Ajax();
        } else {
            include_once $this->_basedir . "/includes/class-wpjobboard-ga-frontend.php";
            $this->frontend = new Wpjobboard_Ga_Frontend();
        }
        
        add_action( "init", array( $this, "init" ) );
    }
    
    /**
     * Singleton
     * 
     * Creates if NULL and returns Wpjobboard_Ga instance
     * 
     * @since 1.0
     * @return Wpjobboard_Ga
     */
    public static function get_instance() {
        if( self::$_instance === null ) {
            self::$_instance = new self();
        }
        
        return self::$_instance;
    }
    
    /**
     * Returns basedir path
     * 
     * @since 1.0
     * @return string   Basedir path (eg. /public_html/wp-content/plugins/wpjobboard-ga)
     */
    public function get_basedir() {
        return $this->_basedir;
    }
    
    /**
     * Returns plugin base URL
     * 
     * @since 1.0
     * @return string   Basedir path (eg. http://example.com/wp-content/plugins/wpjobboard-ga)
     */
    public function get_baseurl() {
        return $this->_baseurl;
    }
    
    /**
     * General Init Function
     * 
     * This function is executed in both frontend and wp-admin
     * 
     * @since 1.0
     * @return void
     */
    public function init() {
        
    }
    
    /**
     * Returns applications stats ready to use with chart.
     * 
     * @global wpdb $wpdb   wodb object
     * @param int $job_id   Job ID
     * @return array
     */
    public static function get_applications_for_chart( $job_id ) {
        global $wpdb;
        
  
        $select = ""
          . "SELECT COUNT(id) AS `count`, DATE_FORMAT(applied_at, '%%Y%%m%%d') AS `formatted_date` "
          . "FROM `{$wpdb->prefix}wpjb_application` WHERE job_id = %d "
          . "GROUP BY YEAR(applied_at), MONTH(applied_at), DAY(applied_at)";
        
        
        $prepared = $wpdb->prepare( $select, $job_id );
        $apps = $wpdb->get_results( $prepared );
        
        $result = array();
        foreach( $apps as $app ) {
            $result[$app->formatted_date] = $app->count;
        }
        
        return $result;
        
    }

}
