<?php

class Wpjobboard_Ga_Form_Config extends Daq_Form_Abstract 
{

    public function init()
    {
        $data = get_option( "wpjobboard_ga_config" );
        
        $e = $this->create("service_name");
        $e->setRequired(true);
        $e->setLabel( __( "Application Name", "wpjobboard-ga" ) );
        $e->setAttr( "placeholder", __( "e.g. My Application", "wpjobboard-ga" ) );
        $e->setValue( isset( $data["service_name" ] ) ? $data["service_name"] : "" );
        $this->addElement( $e );
        
        $e = $this->create("service_email");
        $e->setRequired(true);
        $e->setLabel( __( "Service Email", "wpjobboard-ga" ) );
        $e->setValue( isset( $data["service_email" ] ) ? $data["service_email"] : "" );
        $e->addValidator(new Daq_Validate_Email());
        $this->addElement( $e );
        
        $e = $this->create("service_key", "textarea");
        $e->setRequired(true);
        $e->setLabel( __( "Key", "wpjobboard-ga" ) );
        $e->setValue( isset( $data["service_key" ] ) ? $data["service_key"] : "" );
        $e->setAttr("cols", "42");
        $e->setAttr("rows", "10");
        $this->addElement( $e );
        
    }
    
}
