// Init global namespace
var WPJB = WPJB || {};
// Init addons namespace
WPJB.Addon = WPJB.Addon || {};

WPJB.Addon.Ga = {
    
};

WPJB.Addon.Ga.Actions = function(elements) {
    this.element = elements
    this.chart = null;
    
    
    this.element.button.on( "click", jQuery.proxy( this.click, this ) );
};

WPJB.Addon.Ga.Actions.prototype.click = function(e) {
    e.preventDefault();
    
    if(this.chart !== null) {
        this.element.chart.slideToggle("fast");
    } else {
        this.element.loader.show();
        this.element.chart.slideToggle("fast", jQuery.proxy( this.chart_load, this ) );
    }
};

WPJB.Addon.Ga.Actions.prototype.chart_load = function(e) {
    jQuery.ajax({
        url: wpjobboard_ga_lang.ajaxurl,
        type: "post",
        data: {
            action: "wpjobboard_ga_data",
            id: this.element.chart.data("id"),
            object_type: "job",
            date_from: this.element.chart.data("date-from"),
            date_to: this.element.chart.data("date-to")
        },
        dataType: "json",
        success: jQuery.proxy( this.chart_render, this ),
        error: jQuery.proxy( this.chart_error, this )
    });
};

WPJB.Addon.Ga.Actions.prototype.chart_render = function(response) {

    this.element.loader.hide();
    this.element.canvas.show();

    this.chart = new Chart(this.element.canvas, {
        type: 'bar',
        data: {
            labels: response.labels,
            datasets: [{
                type: 'line',
                label: response.label.x1,
                data: response.x1,
                fill: true,
                lineTension: 0.1,
                backgroundColor: "rgba(53, 114, 176, 0)",
                borderColor: "rgba(53, 114, 176, 1)",
                borderCapStyle: 'butt',
                borderDash: [],
                borderDashOffset: 0.0,
                borderJoinStyle: 'miter',
                pointBorderColor: "rgba(53, 114, 176, 1)",
                pointBackgroundColor: "rgba(53, 114, 176, 0)",
                pointBorderWidth: 2,
                pointHoverRadius: 3,
                pointHoverBackgroundColor: "rgba(53, 114, 176, 0.4)",
                pointHoverBorderColor: "rgba(53, 114, 176, 1)",
                pointHoverBorderWidth: 1,
                pointRadius: 1,
                pointHitRadius: 10,
                spanGaps: false
            }, {
                type: 'bar',
                label: response.label.x2,
                data: response.x2,
                backgroundColor: "rgba(142, 176, 33, 0.6)"
            }]
        },
        options: {
            title: {
                display: true,
                text: wpjobboard_ga_lang.job_chart_title
            },
            legend: {
                position: "top",
                fullWidth: false,
            },
            scales: {
                xAxes: [{
                    display: false
                }]
            }
        }
    });
    
    jQuery.each( response.stats, jQuery.proxy( this.stats_update, this ) );
};

WPJB.Addon.Ga.Actions.prototype.stats_update = function(index, item) {
    this.element.stat[index].show();
    this.element.stat[index].find(".wpjobboard-ga-stat-value").text(item.current);


    var change = this.element.stat[index].find(".wpjobboard-ga-stat-change");

    if(item.change === null) {
        change.hide();
    } else if(item.change == 0) {
        change.show();
        change.removeClass("wpjobboard-ga-stat-up");
        change.removeClass("wpjobboard-ga-stat-down");
        change.text(" —");
        change.attr("title", wpjobboard_ga_lang.no_changes);
    } else {
        change.show();
        change.removeClass("wpjobboard-ga-stat-up");
        change.removeClass("wpjobboard-ga-stat-down");
        change.text(item.change+"%");
        change.attr("title", wpjobboard_ga_lang.compared_to.replace("%d", item.previous));
    }

    if(item.change > 0) {
        change.addClass("wpjobboard-ga-stat-up");
    } else if(item.change < 0) {
        change.addClass("wpjobboard-ga-stat-down");
    }

}

WPJB.Addon.Ga.Actions.prototype.chart_error = function(response) {
    this.element.loader.hide();
    alert(response.message);
};

jQuery(function($) {
    $(".wpjobboard-ga-analytics-button").each(function(index, item) {
        
        var chart = $(".wpjobboard-ga-chart-"+$(item).data("post-id"));
        
        new WPJB.Addon.Ga.Actions({
            button: $(item),
            chart: chart,
            canvas: chart.find(".wpjobboard-ga-canvas"),
            loader: chart.find(".wpjobboard-ga-chart-loader"),
            stat: {
                pageviews: chart.find(".wpjobboard-ga-stat-pageviews"),
                unique: chart.find(".wpjobboard-ga-stat-unique"),
                applications: chart.find(".wpjobboard-ga-stat-applications")
            }
        });
        
    });
});