// Init global namespace
var WPJB = WPJB || {};
// Init addons namespace
WPJB.Addon = WPJB.Addon || {};

WPJB.Addon.GaAdmin = {
    Stats: {
        
    }
};

WPJB.Addon.GaAdmin.Stats.Sidebar = function() {
    
    this.xhr = null;
    this.cache = [];
    
    this.element = {
        loader: jQuery(".wpjobboard-ga-stat-loader"),
        loaded: jQuery(".wpjobboard-ga-stat-loaded"),
        range: jQuery("#wpjobboard-ga-period"),
        button: jQuery("#wpjobboard-ga-admin-chart-button"),
        
    };
    
    this.stat = {
        pageviews: jQuery("#wpjobboard-ga-stat-pageviews"),
        unique: jQuery("#wpjobboard-ga-stat-unique"),
        applications: jQuery("#wpjobboard-ga-stat-applications")
    };
    
    this.chart = {
        dialog: jQuery("#wpjobboard-ga-admin-chart-dialog"),
        loader: jQuery(".wpjobboard-ga-admin-chart-loader"),
        range: jQuery("#wpjobboard-ga-admin-chart-range"),
        range_from: jQuery("#wpjobboard-ga-admin-range-from"),
        range_to: jQuery("#wpjobboard-ga-admin-range-to"),
        canvas: jQuery("#wpjobboard-ga-admin-chart-canvas"),
        stats: jQuery("#wpjobboard-ga-admin-stats"),
        stat: {
            pageviews: jQuery("#wpjobboard-ga-chart-stat-pageviews"),
            unique: jQuery("#wpjobboard-ga-chart-stat-unique"),
            applications: jQuery("#wpjobboard-ga-chart-stat-applications")
        }
    };
    
    
    this.canvas = null;
    
    this.chart.range_from.datepicker({
        onSelect: jQuery.proxy( this.date_from_changed, this ),
        dateFormat: "yy-mm-dd",
        minDate: -365,
        maxDate: "today"
    });
    this.chart.range_to.datepicker({
        onSelect: jQuery.proxy( this.date_to_changed, this ),
        dateFormat: "yy-mm-dd",
        minDate: -365,
        maxDate: "today"
    });
    
    this.chart.range.on( "change", jQuery.proxy( this.chart_range, this ) );
    
    this.element.range.on( "change", jQuery.proxy( this.range_changed, this ) );
    this.element.button.on( "click", jQuery.proxy( this.button_clicked, this ) );
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.date_from_changed = function() {
    this.chart.range_to.datepicker( "option", "minDate", this.chart.range_from.datepicker( "getDate" ) );
    this.chart_load();
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.date_to_changed = function() {
    this.chart.range_from.datepicker( "option", "maxDate", this.chart.range_to.datepicker( "getDate" ) );
    this.chart_load();
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.chart_range = function() {
    if(this.chart.range.val() != "custom") {
        this.chart.range_from.datepicker( "option", "disabled", true );
        this.chart.range_to.datepicker( "option", "disabled", true );
    } else {
        this.chart.range_from.datepicker( "option", "disabled", false );
        this.chart.range_to.datepicker( "option", "disabled", false );
        
        this.chart.range_from.datepicker()
    }
    
    var selected = this.chart.range.find("option:selected");
    
    this.chart.range_from.datepicker( "setDate", selected.data("date-from"));
    this.chart.range_to.datepicker( "setDate", selected.data("date-to"));
    
    this.chart_load();
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.button_clicked = function(e) {
    if(typeof e !== 'undefined') {
        e.preventDefault();
    }
    
    this.chart.dialog.dialog({
        resizable: false,
        height: 'auto',
        width: 800,
        modal: true,
        buttons: []
    });
    
    if(this.canvas === null) {
        this.chart_range();
    }
    
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.chart_load = function() {
    
    if( this.canvas ) {
        this.canvas.clear();
        this.canvas.destroy();
        this.canvas = null;
    }
    
    if( this.xhr ) {
        this.xhr.abort();
    }
    
    var date_from = this.chart.range_from.datepicker( { dateFormat: 'yy-mm-dd' } ).val();
    var date_to = this.chart.range_to.datepicker( { dateFormat: 'yy-mm-dd' } ).val();
    
    if( this.cache[date_from+"|"+date_to] ) {
        this.chart_render(this.cache[date_from+"|"+date_to]);
        return;
    }
    
    this.chart.loader.show();
    this.chart.canvas.hide();
    this.chart.stats.hide();
    
    this.xhr = jQuery.ajax({
        url: ajaxurl,
        type: "post",
        data: {
            action: "wpjobboard_ga_data",
            id: this.chart.canvas.data("id"),
            object_type: this.chart.canvas.data("object-type"),
            date_from: date_from,
            date_to: date_to
        },
        dataType: "json",
        success: jQuery.proxy( this.chart_render, this ),
        error: jQuery.proxy( this.chart_error, this )
    });
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.chart_render = function(response) {

    if(this.canvas !== null) {
        return;
    }
    
    if(response.result == 0) {
        this.chart_error(response);
    }

    this.cache[response.request_key] = response;

    this.chart.loader.hide();
    this.chart.canvas.show();
    this.chart.stats.show();

    this.canvas = new Chart(this.chart.canvas, {
        type: 'bar',
        data: {
            labels: response.labels,
            datasets: [{
                type: 'line',
                label: response.label.x1,
                data: response.x1,
                fill: true,
                lineTension: 0.1,
                backgroundColor: "rgba(53, 114, 176, 0)",
                borderColor: "rgba(53, 114, 176, 1)",
                borderCapStyle: 'butt',
                borderDash: [],
                borderDashOffset: 0.0,
                borderJoinStyle: 'miter',
                pointBorderColor: "rgba(53, 114, 176, 1)",
                pointBackgroundColor: "rgba(53, 114, 176, 0)",
                pointBorderWidth: 2,
                pointHoverRadius: 3,
                pointHoverBackgroundColor: "rgba(53, 114, 176, 0.4)",
                pointHoverBorderColor: "rgba(53, 114, 176, 1)",
                pointHoverBorderWidth: 1,
                pointRadius: 1,
                pointHitRadius: 10,
                spanGaps: false
            }, {
                type: 'bar',
                label: response.label.x2,
                data: response.x2,
                backgroundColor: "rgba(142, 176, 33, 0.6)"
            }]
        },
        options: {
            legend: {
                position: "top",
                fullWidth: false,
            },
            scales: {
                xAxes: [{
                    display: false
                }]
            }
        }
    });
    
    jQuery.each(response.stats, jQuery.proxy( this.stats_update, this ) );
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.stats_update = function(index, item) {
    this.chart.stat[index].show();
    this.chart.stat[index].find(".wpjobboard-ga-stat-value").text(item.current);


    var change = this.chart.stat[index].find(".wpjobboard-ga-stat-change");

    if(item.change === null) {
        change.hide();
    } else if(item.change == 0) {
        change.show();
        change.removeClass("wpjobboard-ga-stat-up");
        change.removeClass("wpjobboard-ga-stat-down");
        change.text(" —");
        change.attr("title", wpjobboard_ga_admin_lang.no_changes);
    } else {
        change.show();
        change.removeClass("wpjobboard-ga-stat-up");
        change.removeClass("wpjobboard-ga-stat-down");
        change.text(item.change+"%");
        change.attr("title", wpjobboard_ga_admin_lang.compared_to.replace("%d", item.previous));
    }

    if(item.change > 0) {
        change.addClass("wpjobboard-ga-stat-up");
    } else if(item.change < 0) {
        change.addClass("wpjobboard-ga-stat-down");
    }
}

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.chart_error = function(response) {
    
    this.element.loader.hide();
    
    if( response.statusText == "abort" ) {
        return;
    }
    
    alert(response.message);
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.range_changed = function() {
    this.element.loader.show();
    this.element.loaded.hide();
    
    
    var selected = this.element.range.find("option:selected");
    
    var data = {
        action: "wpjobboard_ga_data",
        id: this.chart.canvas.data("id"),
        object_type: this.chart.canvas.data("object-type"),
        date_from: selected.data("date-from"),
        date_to: selected.data("date-to")
        
    };
    
    jQuery.ajax({
        url: ajaxurl,
        data: data,
        dataType: "json",
        type: "post",
        success: jQuery.proxy( this.range_success, this ),
        error: jQuery.proxy( this.range_error, this )
    });
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.range_success = function(response) {
    this.element.loader.hide();
    this.element.loaded.show();
    this.cache[response.request_key] = response;

    var $this = this;
    
    jQuery.each(response.stats, function(index, item) {

        $this.stat[index].show();
        $this.stat[index].find(".wpjobboard-ga-stat-value").text(item.current);
        
        
        var change = $this.stat[index].find(".wpjobboard-ga-stat-change");
        
        if(item.change === null) {
            change.hide();
        } else if(item.change == 0) {
            change.show();
            change.removeClass("wpjobboard-ga-stat-up");
            change.removeClass("wpjobboard-ga-stat-down");
            change.text(" —");
            change.attr("title", wpjobboard_ga_admin_lang.no_changes);
        } else {
            change.show();
            change.removeClass("wpjobboard-ga-stat-up");
            change.removeClass("wpjobboard-ga-stat-down");
            change.text(item.change+"%");
            change.attr("title", wpjobboard_ga_admin_lang.compared_to.replace("%d", item.previous));
        }
        
        if(item.change > 0) {
            change.addClass("wpjobboard-ga-stat-up");
        } else if(item.change < 0) {
            change.addClass("wpjobboard-ga-stat-down");
        }
        
    });
};

WPJB.Addon.GaAdmin.Stats.Sidebar.prototype.range_error = function() {
    
};

jQuery(function($) {
    var sidebar = new WPJB.Addon.GaAdmin.Stats.Sidebar();
    sidebar.range_changed();
});