<?php if( ! defined( "ABSPATH" ) ) exit; ?>

<div class="wrap wpjb">
   
    <h1>
        <?php echo __( "WPJobBoard - Google Analytics Configuration", "wpjobboard-ga" ) ?>
    </h1>

    <?php if( $form_error ): ?>
        <div class="wpjb-flash wpjb-flash-error"><?php echo esc_html( $form_error ) ?></div>
    <?php endif; ?>

        
    <?php if(isset($options) && $options): ?>
        

    <form action="" method="post" class="wpjb-form">
        <table class="form-table">
            <tbody>
                <tr valign="top" class="">
                    <th scope="row">
                        <label><?php _e( "Application Name", "wpjobboard-ga" ) ?></label>
                    </th>
                    <td>
                        <?php echo esc_html( $service["service_name"] ) ?>
                    </td>
                </tr>
                <tr valign="top" class="">
                    <th scope="row">
                        <label><?php _e( "Service Email", "wpjobboard-ga" ) ?></label>
                    </th>
                    <td>
                        <?php echo esc_html( $service["service_email"] ) ?>
                    </td>
                </tr>
                <tr valign="top" class="">
                    <th scope="row">
                        <label><?php _e( "Reset Configuration", "wpjobboard-ga" ) ?></label>
                    </th>
                    <td>
                        <a href="<?php echo add_query_arg(array( "reset-all" => "1", "noheader" => "1")) ?>" class="button"><?php _e( "Reset Analytics Configuration", "wpjobboard-ga" ) ?></a>
        
                    </td>
                </tr>
                <tr valign="top" class="">
                    <th scope="row">
                        <label>
                            <?php echo __( "Select Service", "wpjobboard-ga") ?>
                        </label>
                    </th>
                    <td>
                        <div class="wpjobboard-ga-properties-list">
                        <?php foreach($options as $account): ?>
                        <span class="wpjobboard-ga-account-title"><?php echo esc_html( $account["name"] ) ?></span>
                        <?php foreach($account["properties"] as $prop): ?>
                            <div class="wpjobboard-ga-property">
                                <input type="radio" name="service_uid" value="<?php echo esc_attr( $account["id"]."|".$prop["id"] ) ?>" <?php checked( $account["id"]."|".$prop["id"], $service_uid ) ?> />
                                <div class="wpjobboard-ga-propery-description">
                                    <strong><?php echo esc_html( $prop["name"] ) ?></strong> <br/>
                                    <?php echo esc_html( $prop["id"]) ?> <span style="opacity: 0.5"><?php echo esc_html( $prop["website_url"] ) ?></span>
                                </div>

                            </div>
                        <?php endforeach; ?>
                        <?php endforeach; ?>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>

        <p class="submit">
            <input type="submit" value="<?php _e( "Save", "wpjobboard-ga" ) ?>" class="button-primary button" name="wpjobboard_ga_uid" />
        </p>

    </form>
        

    <?php else: ?>
        
    <form action="" method="post" class="wpjb-form">
        <table class="form-table">
            <tbody>
                <?php echo daq_form_layout_config($form) ?>
            </tbody>
        </table>

        <p class="submit">
            <input type="submit" value="<?php _e( "Save", "wpjobboard-ga" ) ?>" class="button-primary button" name="wpjobboard_ga_config" />
        </p>

    </form>
        
    <?php endif; ?>

</div>

<style type="text/css">

    .wpjobboard-ga-property input[type=radio] {
        display: block;
        float: left;
        margin: 0.7em 0.7em 0.7em 0;
    }
    
    .wpjobboard-ga-propery-description {
        float: left;
    }
    
    .wpjobboard-ga-properties-list {
        clear: both;
        overflow: hidden;
    }
    
    .wpjobboard-ga-property {
        width: 100%;
        margin: 0 0 1em 0;
        clear: both;
        overflow: hidden;
    }
    
    .wpjobboard-ga-account-title {
        margin: 0.2em 0 0.7em 0;
        font-size: 1.3em;
        font-weight: bold;
        display: block;
    }
    
    
</style>