<?php

// Bail if called directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Wpjobboard_Ca_Refresh {

    
    /**
     * Admin Constructor
     * 
     * Creates object which manages WPJB AM integration options.
     * 
     * @since 1.0
     * @return Wpjobboard_Am_Admin
     */
    public function __construct() {
        
        add_action( "init", array( $this, "init" ) );
    }
    
    /**
     * Admin Init
     * 
     * Initiates wp-admin actions and filters
     * 
     * @since 1.0
     * @return void
     */
    public function init() {
        
        add_action( 'wp_ajax_wpjb_ca_get_ids', array( &$this, 'wpjb_ca_get_ids' ) );
        add_action( 'wp_ajax_wpjb_ca_anonymize', array( &$this, 'wpjb_ca_anonymize' ) );
    }
    
    /**
     * Ajax Function that returns number of objects of given type.
     */
    function wpjb_ca_get_ids() {

        $request = Daq_Request::getInstance();
        $type = $request->post('type', false);
        $response = new stdClass();

        if($type == false) {
            $response->status = -5;
            $response->msg = __("Wrong type provided", 'wpjb-debugger');
            $response->ids = null;
            echo json_encode($response);
            wp_die();
        }

        $q = new Daq_Db_Query();
        $objects = $q->select(' COUNT(t.id) AS cnt')->from("Wpjb_Model_".ucfirst($type)." t")->fetchColumn();

        $response->status = 200;
        $response->msg = __("", 'wpjb-debugger');
        $response->count = $objects;

        echo json_encode($response);
        wp_die();
    }

    /**
     * Ajax function that refresh object
     */
    function wpjb_ca_anonymize() {

        $per_page = 25;

        $request = Daq_Request::getInstance();
        $type = $request->post('type', false);
        $records_number = $request->post('records_number', 0);
        $last = $request->post('last', 0);
        $response = new stdClass();
        $haveMore = ture;

        $class = "Wpjb_Model_" . ucfirst($type);

        if( ( $last + $per_page ) >= $records_number) {
            $haveMore = false;
        }

        $q = new Daq_Db_Query();
        $objects = $q->select()->from( $class . " t" )->limit( $per_page, $last )->execute();
        foreach($objects as $object) {

            $object->candidate_slug = Wpjb_Utility_Slug::generate( Wpjb_Utility_Slug::MODEL_RESUME, $object->getSearch(true)->fullname, $object->id );
            $object->save();
            $object->cpt();
            
            $last++;
        }

        $response->last = $last;
        $response->haveMore = $haveMore;
        $response->records_number = $records_number;

        echo json_encode($response);
        wp_die();
    }


}