<?php

/**
* Form for Candidate Anonymizer Config
* 
* @since 1.0
* @access public
*/
class Wpjobboard_Ca_Config_Form extends Daq_Form_Abstract {
    
    public $name = null;
    
    
    public function init()
    {       
        $this->name = __( "Candidate Anonymizer Configuration", "wpjobboard-ca" );
        
        $this->addGroup( "default", __( "Basic Configuration", "wpjobboard-ca" ) );
        $this->addGroup( "debugger", __( "Refresh Slug", "wpjobboard-ca" ) );
        
        $e = new Daq_Form_Element_Checkbox('wpjobboard_ca_hide');
        $e->setLabel( __( "Hide Surname", "wpjobboard-ca" ) );
        $e->setHint( __( "Hide candidate name on single resume page, resumes list etc.", "wpjobboard-mc" ) );
        $e->addOption( 1, 1, __( "If checked only firsname and first letter of last name of Candidate will be visible.", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "wpjobboard_ca_hide", 0 ) );
        $this->addElement( $e, "default" );
        
        $e = new Daq_Form_Element_Select('wpjobboard_ca_hide_exception');
        $e->setLabel( __( "Hide Surname Exceptions", "wpjobboard-ca" ) );
        $e->setHint( __( "Who can see full candidate surname. Admin can alwyas see full name, also currently logged Candidate can see his fullname", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "wpjobboard_hide_exception" ) );
        $e->setEmptyOption( true );
        $e->addOption( 1, 1, __( "Signed Users" ) );
        $e->addOption( 2, 2, __( "Premium Members" ) );
        $this->addElement( $e, "default" );
        
        $e = new Daq_Form_Element_Select('wpjobboard_ca_slug');
        $e->setLabel( __( "Slug Pattern", "wpjobboard-ca" ) );
        //$e->setHint( __( "Define pattern for candidate slug. Slug is visible in address bar in browser. Default is candidate first name and last name. You can use candidate variables.", "wpjobboard-mc" ) );
        $e->addOption( "{\$first_name}-{\$last_name}", "{\$first_name}-{\$last_name}", __("{\$first_name}-{\$last_name} (e.g.: joe-doe) [Default]") );
        $e->addOption( "{\$first_name}-{\$first_letter_of_last_name}", "{\$first_name}-{\$first_letter_of_last_name}", __("{\$first_name}-{\$first_letter_of_last_name} (e.g.: joe-d)") );
        $e->addOption( "resume-{\$id}", "resume-{\$id}", __("resume-{\$id} (e.g.: resume-123)") );
        $e->addOption( "{\$id}", "{\$id}", __("{\$id} (e.g.: 123)") );
        $e->addOption( "{\$first_name}-{\$id}", "{\$first_name}-{\$id}", __("{\$first_name}-{\$id} (e.g.: joe-123)") );
        $e->addOption( "{\$random}", "{\$random}", __("{\$random} (e.g.: hsu32nfu43)") );
        $e->setValue( wpjb_conf( "wpjobboard_ca_slug", 0 ) );
        $this->addElement( $e, "default" );
        
        $e = new Daq_Form_Element_Select('wpjobboard_ca_robots');
        $e->setLabel( __( "Robots Restirctions", "wpjobboard-ca" ) );
        $e->setHint( __( "Allow to add index restrictions for robots, to hide your Candidates names in search engines results.", "wpjobboard-mc" ) );
        $e->setValue( wpjb_conf( "wpjobboard_ca_robots" ) );
        $e->setMaxChoices(2);
        $e->addOption( 'noindex', 'noindex', __( "Robots can't index candidate page (noindex)" ) );
        $e->addOption( 'nofollow', 'nofollow', __( "Robots can't index use links on candidate page (nofollow)" ) );
        $this->addElement( $e, "default" );
        
        $e = new Daq_Form_Element_Text( 'refresh' );
        $e->setLabel( __( "Refresh Candidates Slugs", "wpjobboard-mc" ) );
        //$e->setHint( __( "Add current users to proper lists.", "wpjobboard-mc" ) );
        $e->setRenderer( array( &$this, 'render_refresh' ) );
        $this->addElement( $e, "debugger" );

        
    }
    
    function render_refresh() {

        ob_start();
            include_once Wpjobboard_Ca::get_instance()->get_basedir() . '/templates/debug.php';
        ob_flush();
    }
}