jQuery(function($) {
    
    $('.wpjb-ca-refresh-start').click(function(event) {
        event.preventDefault();
        
        // Prepare for refreshing
        var type = $(this).data('type');
        var plural = $(this).data('plural');
        //var ids = false;
        wpjb_prepare_for_refresh(plural);
        
        // Get id list
        $.ajax({
            url: wpjb_debugger_refresh_lang.ajaxurl + "?action=wpjb_ca_get_ids",
            data: { 
                type: type
            },
            type: 'POST',
            dataType: 'JSON',
            success: function( response ) {                
                
                if(response.status === 200) {
                    $('.wpjb_items_found').html(response.count);
                    $('.wpjb_refresh_process_step_2').show();
                    $('.wpjb_refresh_process_step_3').show();
                    $('.wpjb_refresh_process_step_3 progress').attr('value', 0);
                    $('.wpjb_refresh_process_step_3 progress').attr('max', response.count);
                    
                    //ids = response.ids;
                    wpjb_debugger_refresh(type, 0, response.count);
                    
                } else {
                    $('.wpjb-refresh-start').show();
                    $('.wpjb_refresh_process').append('<span class="wpjb_debugger_error">Process aborted: '+response.msg+'</span>');      
                }
            }
        });
        
    });
    
    $('.wpjb-refresh-clear').click(function(event) {
        wpjb_clean_refresh();
    });
       
    function wpjb_prepare_for_refresh(type) {
        
        wpjb_clean_refresh();
    
        $('.wpjb-refresh-start').hide();
        $('.wpjb_refreshing_type').html(type);


        $(".wpjb_refresh_process").show();
        $(".wpjb_refresh_process_step_1").show(); 
    }
    
    function wpjb_clean_refresh() {   
        
        $('.wpjb-refresh-start').show();
        
        $(".wpjb_refresh_process_step_1").hide(); 
        $(".wpjb_refresh_process_step_2").hide(); 
        $(".wpjb_refresh_process_step_3").hide(); 
        $(".wpjb_refresh_process_step_4").hide(); 
        $(".wpjb_refresh_process").hide();
    }
    
    function wpjb_debugger_refresh(type, last_id, records_number) {
        $.ajax({
            url: wpjb_debugger_refresh_lang.ajaxurl + "?action=wpjb_ca_anonymize",
            data: { 
                type: type,
                last: last_id,
                records_number: records_number,
            },
            type: 'POST',
            dataType: 'JSON',
            success: function( response ) {                

                $('.wpjb_refresh_process_step_3 progress').attr('value', (response.last * 1 + 1));

                if(response.haveMore) {  
                    wpjb_debugger_refresh(type, response.last, response.records_number);
                    
                } else {
                    $('.wpjb_refresh_process_step_4').show();
                    $('.wpjb-refresh-start').show();
                }
            }
        });
    }
    
});


