<?php

class Wpjb_Lubandi
{
    /**
     * Wpjb_Lubandi Singleton
     * 
     * @var Wpjb_Lubandi
     */
    protected static $_instance = null;

    /**
     * Path to wpjb-lubandi (eg. /public_html/wp-content/plugins/wpjb-lubandi)
     *
     * @var string
     */
    protected $_basedir = null;

    /**
     * URL to wpjb-lubandi (eg. http://example.com/wp-content/plugins/wpjb-lubandi)
     *
     * @var string
     */
    protected $_baseurl = null;


    /**
     * Object contructor
     * 
     * Protected constructor allows to create only one instance of this class.
     * 
     * @since 1.0
     * @return Wpjb_Lubandi
     */
    protected function __construct() {

        $this->_basedir = dirname( dirname( __FILE__ ) );
        $this->_baseurl = plugin_dir_url( dirname( __FILE__ ) );
        
        if( !shortcode_exists( "wpjb_popular_jobs" ) ) {
            add_shortcode( "wpjb_popular_jobs", array( $this, "wpjb_popular_jobs" ) );
        }

        add_action( 'init', array( $this, 'init' ));
    }

    /**
     * Singleton
     * 
     * Creates if NULL and returns Wpjb_Lubandi instance
     * 
     * @since 1.0
     * @return Wpjb_Lubandi
     */
    public static function get_instance() {
        if( self::$_instance === null ) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * Returns basedir path
     * 
     * @since 1.0
     * @return string   Basedir path (eg. /public_html/wp-content/plugins/wpjb-lubandi)
     */
    public function get_basedir() {
        return $this->_basedir;
    }

    /**
     * Returns plugin base URL
     * 
     * @since 1.0
     * @return string   Basedir path (eg. http://example.com/wp-content/plugins/wpjb-lubandi)
     */
    public function get_baseurl() {
        return $this->_baseurl;
    }


    /**
     * General Init Function
     * 
     * This function is executed in both frontend and wp-admin
     * 
     * @since 1.0
     * @return void
     */
    public function init() {

        wpjb_meta_register("job", "final_expiration");
        
        add_filter( "wpjb_form_init_job", array( &$this, "wpjb_form_init_job" ) );
        add_filter( "wpja_form_init_job", array( &$this, "wpjb_form_init_job" ) );
        add_filter( "wpjb_jobs_query", array( &$this, "wpjb_jobs_query" ), 10, 2 );
        add_filter( "wpjb_jobs_query_groupresults", array( &$this, "wpjb_jobs_query_groupresults" ) );
        
        add_filter( "wpjb_form_init_alert", array( &$this, "wpjb_form_init_alert" ) );
        
        add_filter( "wpjb_config_sections", array( &$this, "wpjb_config_sections" ) );
        
        add_action( 'added_post_meta', array( &$this, "save_pageviews" ), 10, 4 );
        add_action( 'updated_post_meta', array( &$this, "save_pageviews" ), 10, 4 );
       
    }


    public function wpjb_popular_jobs( $atts ) {
        
        $request = Daq_Request::getInstance();
        
        $atts = shortcode_atts(
        array(
            'count' => 20,
        ), $atts );
                
        
        $args = array(
            "post_type" => "job",
            'post_status' => 'publish',
            //"orderby" => 'post_date',
            "meta_key" => 'wpjobboard_lub_pageviews',
            'orderby' => 'meta_value_num',
            "order" => 'DESC',
            /*'date_query' => array(
                array(
                    'after' => '-30 days',
                    'column' => 'post_date',
                ),
            ),*/
            "posts_per_page" => -1,
        );

        $query = new WP_Query($args);
        
        /*$ids = array();
        while ( $query->have_posts() ) {
            $post = $query->the_post();
            $id = get_the_ID();
            $pageViews = $this->object_stats($id);
            if( $pageViews > 0 ) {
                $ids[$id] = $pageViews;
            }
        }*/
        
        
        
        if( !$query->have_posts() ) {
            $flash = new Wpjb_Utility_Session();
            $flash->addError( __( "No popular jobs recorder by Google Analytics", "wpjobboard" ) );
            
            ob_start();
            wpjb_flash();
            $content = ob_get_clean();
            
            return $content;
        }

        
        //$jobs = $this->search( array( "post_id" => array_keys( $ids ) ) );

        wp_enqueue_style("wpjb-css");
        wp_enqueue_script('wpjb-js');
        
        
        ob_start(); ?>
        <div id="wpjb-main" class="wpjb-job wpjb-page-single wpjb">
            <div class="wpjb-job-content wpjb-related-jobs">
                <ul>
                    <?php while ( $query->have_posts() ): //foreach($jobs->job as $i => $job): ?>
                    <?php $query->the_post(); ?>
                    <li class="<?php //wpjb_job_features($job); ?>">

                        <?php if ( $this->isNew( get_the_date() ) ): ?><span class="btn wpjb-new-related wpjb-new-btn"><?php _e("New", "jobeleon") ?></span><?php endif; ?>
                        <a href="<?php echo get_permalink() //echo wpjb_link_to("job", $job); ?>"><?php the_title() ?></a>
                        <span class="wpjb-related-posted"><?php wpjb_time_ago( get_the_date() , __("posted {time_ago} ago.", "jobeleon")) ?></span>
                    </li>
                    <?php if( $i == $atts['count'] ): break; endif; ?>
                    <?php endwhile; //endforeach; ?>
                </ul>
            </div>
        </div>


        <!--div class="wpjb-grid wpjb-grid-closed-top wpjb-grid-compact">
            <?php foreach($jobs->job as $job): ?>
            <?php /* @var $job Wpjb_Model_Job */ ?>
                <div class="wpjb-grid-row <?php wpjb_job_features($job); ?>">
                    <div class="wpjb-grid-col wpjb-col-70">
                        <a href="<?php echo wpjb_link_to("job", $job); ?>"><?php echo esc_html($job->job_title) ?></a>
                        &nbsp; 
                        <?php if($job->locationToString()): ?>
                        <span class="wpjb-glyphs wpjb-icon-location"><?php echo esc_html($job->locationToString()) ?></span>
                        <?php endif; ?>
                        <?php if($job->isNew()): ?><span class="wpjb-bulb"><?php _e("new", "wpjobboard") ?></span><?php endif; ?>
                    </div>
                    <div class="wpjb-grid-col wpjb-grid-col-right wpjb-col-30 wpjb-glyphs wpjb-icon-clock">
                    <?php echo wpjb_date_display(get_option('date_format'), $job->job_created_at) ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div-->
        <?php $content = ob_get_clean();
        
        return $content;
        //return $view->render("job-board", "index");
    }

    public function wpjb_form_init_job( $form ) {
        
        $e = $form->create( "final_expiration", "text_date" );
        $e->setLabel( __( "Final Expiration", "wpjb-lubandi" ) );
        $e->setHint( __( "After job will expire, it will be still visibile unitll choosed date", "wpjb-lubandi" ) );
        $e->addClass("wpjb-date-picker");
        if( isset( $form->getObject()->meta->final_expiration ) && $form->getObject()->meta->final_expiration->value() != null ) {
            $e->setValue( $form->getObject()->meta->final_expiration->value() );
        } else {
            $e->setValue( date( wpjb_date_format(), strtotime( "+".wpjb_conf( "wpjb_lubandi_days", 60 )."days" ) ) );
        }
        $e->setDateFormat(wpjb_date_format());
        $e->setAttr("readonly", "readonly");
        $e->setBuiltin( false );
        $form->addElement( $e, "job" );
        
        wp_enqueue_script("wpjb-vendor-datepicker");
        wp_enqueue_style("wpjb-vendor-datepicker");
        
        return $form;
    }
    
    public function wpjb_jobs_query( $select, $params ) {
        
        if( is_admin() ) {
            return $select;
        }
        
        $category = null;
        $type = null;
        $posted = null;
        $query = null;
        $location = null;
        $page = null;
        $date_from = null;
        $date_to = null;
        $expires_from = null;
        $expires_to = null;
        
        /**
         * @var $exclude_imported boolean
         * set this value to true if you only want to get jobs entered manually
         * or imported from XML file (exclude jobs from Indeed, CB and etc.)
         */
        $exclude_imported = false;
        
        /**
         * @var $radius string
         * location radius either in km (for example "5 km") or miles ("5 mi.")
         */
        $radius = null;

        /**
         * @var $count int
         * items per page or maximum number of elements to return
         */
        $count = 20;
        
        /**
         * @var $sort_order mixed
         * string or array, specify sort column and order (either DESC or ASC),
         * you can add more then one sort order. 
         */
        $sort_order = "t1.is_featured DESC, t1.job_created_at DESC, t1.id DESC";
        
        /**
         * @var $count_only boolean
         * Count jobs only
         */
        $count_only = false;
        
        /**
         * Return only list of job ids instead of objects
         * @var $ids_only boolean
         */
        $ids_only = false;
        
        /**
         * Do not show filled jobs on the list
         * @var $hide_filled boolean
         */
        $hide_filled = wpjb_conf("front_hide_filled", false);
        
        /**
         * @var $filter string
         * narrow jobs to certain type:
         * - all: all jobs
         * - active: only active jobs
         * - expired: expired jobs
         * - expiring: jobs which will expire in X days
         * - awaiting: jobs awaiting approval
         * - new: posted no longer than X days ago
         * - inactive: jobs deactivated
         */
        $filter = "active";
        
        if(isset($params["sort_order"]) && empty($params["sort_order"])) {
            $params["sort_order"] = $sort_order;
        }
        
        extract($params);
        
        $groupResults = false;
        
        $select = new Daq_Db_Query();
        $select = $select->select("t1.*");
        $select->from("Wpjb_Model_Job t1");
        
        if( $filter == "active" ) {
            $select->where( "t1.is_active = 1");
            $select->where( "t1.job_created_at <= ?", date( "Y-m-d" ) );
            //$select->where( "t1.job_expires_at >= ?", date( "Y-m-d" ) );
        } elseif( $filter == "expired" ) {
            $select->where( "t1.job_expires_at < ?", date( "Y-m-d" ) );
        } elseif( $filter == "expiring" ) {
            $time = strtotime( "today +5 day" );
            $select->where( "t1.is_active = 1" );
            $select->where( "t1.job_expires_at <= ?", date( "Y-m-d", $time ) );
            $select->where( "t1.job_expires_at >= ?", date( "Y-m-d" ) );
        } elseif( $filter == "awaiting" ) {
            $select->where( "t1.is_approved = 0" );
        } elseif( $filter == "new" ) {
            $time = strtotime( "today -5 day" );
            $select->where( "t1.job_created_at >= ?", date( "Y-m-d", $time ) );
        } elseif( $filter == "unread" ) {
            $select->where( "t1.read = 0" );
        } elseif( $filter == "inactive" ) {
            $select->where( "t1.is_active = 0" );
            $select->where( "t1.is_approved = 1" );
        } elseif( $filter == "filled" ) {
            $select->where( "t1.is_filled = 1" );
        }
        
        $m = 90;
        
        $q = new Daq_Db_Query();
        $k = $q->select()->from("Wpjb_Model_Meta t")->where( "t.meta_object = ?", "job")->where("t.name = ?", "final_expiration")->fetchColumn();
                
                
        $select->join("t1.meta t3m$m");
        $t1 = Daq_Db::getInstance()->quoteInto( "t3m$m.meta_id = ?", $k );
        $select->where( "($t1 AND t3m$m.value > ?)", date("Y-m-d" ) );
        
        $groupResults = true;
        
        if(is_array($sort_order)) {
            $select->order(join(",", $sort_order));
        } else {
            $select->order($sort_order);
        }
        
        if( $hide_filled && $filter != "filled" ) {
            $select->where("is_filled = 0");
        }
        
        if( isset($is_featured) && $is_featured == 1 ) {
            $select->where("t1.is_featured = 1");
        } elseif( isset($is_featured) && $is_featured == -1 ) {
            $select->where("t1.is_featured = 0");
        }
        
        if(isset($employer_id) && $employer_id) {
            if(!is_array($employer_id)) {
                $employer_id = explode(",", $employer_id);
            }
            $select->where("t1.employer_id IN(?)", array_map("intval", $employer_id));
        }
        
        if(isset($country) && $country) {
            $select->where("t1.job_country = ?", $country);
        } elseif( isset( $job_country ) && $job_country ) {
            $select->where("t1.job_country = ?", $job_country);
        }
        
        if(isset($state) && $state) {
            $select->where("t1.job_state = ?", $state);
        } elseif( isset( $job_state ) && $job_state ) {
            $select->where("t1.job_state = ?", $job_state);
        }
        
        if(isset($city) && $city) {
            $select->where("t1.job_city = ?", $city);
        } elseif(isset($job_city) && $job_city) {
            $select->where("t1.job_city = ?", $job_city);
        }
        
        if(isset($id) && $id) {
            $select->where("t1.id IN(?)", (array)$id);
        }
        
        if(isset($id__not_in) && $id__not_in) {
            $select->where("t1.id NOT IN(?)", (array)$id__not_in);
        }
        
        if(!empty($category)) {
            if(!is_array($category)) {
                $category = explode(",", $category);
            }
            $select->join("t1.tagged t2c", "t2c.object='job'");
            $select->where("t2c.tag_id IN(?)", array_map("intval", $category));
            $groupResults = true;
        }
        if(!empty($type)) {
            if(!is_array($type)) {
                $type = explode(",", $type);
            }
            $select->join("t1.tagged t2t", "t2t.object='job'");
            $select->where("t2t.tag_id IN(?)", array_map("intval", $type));
            $groupResults = true;
        }

        if($exclude_imported) {
            $select->joinLeft("t1.meta t3ei", "t3ei.meta_id = 16");
            $select->where("t3ei.value IS NULL");
        }

        if(!empty($meta)) {
            $meta = apply_filters( "wpjb_jobs_query_meta", $meta );
            
            $job = new Wpjb_Model_Job();
            $m = 1;
            foreach($meta as $k => $v) {
                if(!is_numeric($k)) {
                    $k = $job->meta->$k->id;
                }
                
                $metaObject = new Wpjb_Model_Meta($k);
                $metaType = $metaObject->conf("type");
                $match = "";
                
                // match: all, one-or-more, exact, like
                
                if(in_array($metaType, array("ui-input-text", "ui-input-textarea"))) {
                    $select->join("t1.meta t3m$m");
                    $t1 = Daq_Db::getInstance()->quoteInto("t3m$m.meta_id = ?", $k);
                    $select->where("($t1 AND t3m$m.value LIKE ?)", "%$v%");
                } else {
                    $select->join("t1.meta t3m$m");
                    $t1 = Daq_Db::getInstance()->quoteInto("t3m$m.meta_id = ?", $k);
                    $select->where("($t1 AND t3m$m.value IN(?))", $v);
                }
                    
                $m++;
            }
            $groupResults = true;
        }

        if($date_from) {
            $select->where("job_created_at >= ?", $date_from);
        }

        if($date_to) {
            $select->where("job_created_at <= ?", $date_to);
        }
        
        if($expires_from) {
            $select->where("job_expires_at >= ?", $expires_from);
        }

        if($expires_to) {
            $select->where("job_expires_at <= ?", $expires_to);
        }
        
        if(strlen($query)>0 || strlen($location)>0) {
            $select->join("t1.search t4");
        }
        
        if($radius && $location) {
            list($distance, $dunit) = explode(" ", trim($radius));
            $select->having("distance < " . intval($distance));
            $select->order("distance ASC");
            $groupResults = true;
        } elseif($location) {
            $locations = explode(' ', $location);
            foreach($locations as $l) {
                $l = trim($l);
                $l = rtrim($l, ',');
                $select->where("t4.location LIKE ?", "%$l%");
            }
        }
        
        if($groupResults) {
            $select->group("t1.id");
        }
        
        $query = preg_replace( apply_filters( "wpjb_query_allowed_chars", '/[^A-Za-z0-9 ]/' ), "", $query );
        
        $fulltext = "MATCH(t4.title, t4.description, t4.company, t4.location)";
        $fulltext.= "AGAINST (? IN BOOLEAN MODE)";
        
        $q = $fulltext;
        $fulltext = str_replace("?", '\'"'.esc_sql($query).'"\'', $q);
        $itemsFound = 0;
        $t = null;
        
        $custom_columns = apply_filters("wpjb_jobs_query_select_columns", "");
        if(is_array($custom_columns)) {
            $custom_columns = join(", ", $custom_columns);
        }
        if(!empty($custom_columns)) {
            $custom_columns = ", ".ltrim($custom_columns, ", ");
        }
        if($radius && $location) {

            list($distance, $dunit) = explode(" ", trim($radius));

            if($dunit == "km") {
                $u = 6371;
            } else {
                $u = 3959;
            }

            $addr = Wpjb_Service_GoogleMaps::locate( apply_filters( "wpjb_narrow_location_search", $location, $params ) );

            $lng = $addr->geo_longitude;
            $lat = $addr->geo_latitude;
            $prefix = $select->getDb()->prefix;

            $qLng = "(SELECT `value` FROM ".$prefix."wpjb_meta_value AS tmp_lng WHERE tmp_lng.object_id=t1.id AND meta_id=6 LIMIT 1)";
            $qLat = "(SELECT `value` FROM ".$prefix."wpjb_meta_value AS tmp_lat WHERE tmp_lat.object_id=t1.id AND meta_id=5 LIMIT 1)";

            $custom_columns .= ", @lng := $qLng AS `lng`, @lat := $qLat AS `lat`, ($u*acos(cos(radians($lat))*cos( radians(@lat))*cos(radians(@lng)-radians($lng))+sin(radians($lat))*sin(radians(@lat)))) AS `distance`";
        }
        
        $select->select("COUNT(*) as `cnt`".$custom_columns);
        
        return $select;
    }
    
    /**
     * Adds config option in Seetings (WPJB)
     * 
     * @param Array $config
     * @return Array
     */
    function wpjb_config_sections($config) {
        
        include_once $this->get_basedir() . "/includes/class-wpjb-lubandi-form.php";
        
        $config[1]['item'][] = array(
            "form"  => "lubandi",
            "class" => "Wpjb_Lubandi_Config_Form",
            "icon"  => "wpjb-icon-user-secret",
            "title" => __("Lubandi Add-on", "wpjobboard-ca"),
            "order" => 10,
        );

        return $config;
    }
    
    private function search($params = array())
    {
        $category = null;
        $type = null;
        $posted = null;
        $query = null;
        $location = null;
        $page = null;
        $date_from = null;
        $date_to = null;
        $expires_from = null;
        $expires_to = null;
        
        /**
         * @var $exclude_imported boolean
         * set this value to true if you only want to get jobs entered manually
         * or imported from XML file (exclude jobs from Indeed, CB and etc.)
         */
        $exclude_imported = false;
        
        /**
         * @var $radius string
         * location radius either in km (for example "5 km") or miles ("5 mi.")
         */
        $radius = null;

        /**
         * @var $count int
         * items per page or maximum number of elements to return
         */
        $count = 20;
        
        /**
         * @var $sort_order mixed
         * string or array, specify sort column and order (either DESC or ASC),
         * you can add more then one sort order. 
         */
        $sort_order = "t1.is_featured DESC, t1.job_created_at DESC, t1.id DESC";
        
        /**
         * @var $count_only boolean
         * Count jobs only
         */
        $count_only = false;
        
        /**
         * Return only list of job ids instead of objects
         * @var $ids_only boolean
         */
        $ids_only = false;
        
        /**
         * Do not show filled jobs on the list
         * @var $hide_filled boolean
         */
        $hide_filled = wpjb_conf("front_hide_filled", false);
        
        /**
         * @var $filter string
         * narrow jobs to certain type:
         * - all: all jobs
         * - active: only active jobs
         * - expired: expired jobs
         * - expiring: jobs which will expire in X days
         * - awaiting: jobs awaiting approval
         * - new: posted no longer than X days ago
         * - inactive: jobs deactivated
         */
        $filter = "active";
        
        if(isset($params["sort_order"]) && empty($params["sort_order"])) {
            $params["sort_order"] = $sort_order;
        }
        
        extract($params);
        
        $groupResults = false;
        
        $select = new Daq_Db_Query();
        $select = $select->select("t1.*");
        $select->from("Wpjb_Model_Job t1");
        
        if( $filter == "active" ) {
            $select->where( "t1.is_active = 1");
            $select->where( "t1.job_created_at <= ?", date( "Y-m-d" ) );
            $select->where( "t1.job_expires_at >= ?", date( "Y-m-d" ) );
        } elseif( $filter == "expired" ) {
            $select->where( "t1.job_expires_at < ?", date( "Y-m-d" ) );
        } elseif( $filter == "expiring" ) {
            $time = strtotime( "today +5 day" );
            $select->where( "t1.is_active = 1" );
            $select->where( "t1.job_expires_at <= ?", date( "Y-m-d", $time ) );
            $select->where( "t1.job_expires_at >= ?", date( "Y-m-d" ) );
        } elseif( $filter == "awaiting" ) {
            $select->where( "t1.is_approved = 0" );
        } elseif( $filter == "new" ) {
            $time = strtotime( "today -5 day" );
            $select->where( "t1.job_created_at >= ?", date( "Y-m-d", $time ) );
        } elseif( $filter == "unread" ) {
            $select->where( "t1.read = 0" );
        } elseif( $filter == "inactive" ) {
            $select->where( "t1.is_active = 0" );
            $select->where( "t1.is_approved = 1" );
        } elseif( $filter == "filled" ) {
            $select->where( "t1.is_filled = 1" );
        }
        
        if(is_array($sort_order)) {
            $select->order(join(",", $sort_order));
        } else {
            $select->order($sort_order);
        }
        
        if( $hide_filled && $filter != "filled" ) {
            $select->where("is_filled = 0");
        }
        
        if( isset($is_featured) && $is_featured == 1 ) {
            $select->where("t1.is_featured = 1");
        } elseif( isset($is_featured) && $is_featured == -1 ) {
            $select->where("t1.is_featured = 0");
        }
        
        if(isset($employer_id) && $employer_id) {
            if(!is_array($employer_id)) {
                $employer_id = explode(",", $employer_id);
            }
            $select->where("t1.employer_id IN(?)", array_map("intval", $employer_id));
        }
        
        if(isset($country) && $country) {
            $select->where("t1.job_country = ?", $country);
        } elseif( isset( $job_country ) && $job_country ) {
            $select->where("t1.job_country = ?", $job_country);
        }
        
        if(isset($state) && $state) {
            $select->where("t1.job_state = ?", $state);
        } elseif( isset( $job_state ) && $job_state ) {
            $select->where("t1.job_state = ?", $job_state);
        }
        
        if(isset($city) && $city) {
            $select->where("t1.job_city = ?", $city);
        } elseif(isset($job_city) && $job_city) {
            $select->where("t1.job_city = ?", $job_city);
        }
        
        if(isset($id) && $id) {
            $select->where("t1.id IN(?)", (array)$id);
        }
        
        if(isset($post_id) && $post_id) {
            $select->where("t1.post_id IN(?)", (array)$post_id);
        }
        
        if(isset($id__not_in) && $id__not_in) {
            $select->where("t1.id NOT IN(?)", (array)$id__not_in);
        }
        
        if(!empty($category)) {
            if(!is_array($category)) {
                $category = explode(",", $category);
            }
            $select->join("t1.tagged t2c", "t2c.object='job'");
            $select->where("t2c.tag_id IN(?)", array_map("intval", $category));
            $groupResults = true;
        }
        if(!empty($type)) {
            if(!is_array($type)) {
                $type = explode(",", $type);
            }
            $select->join("t1.tagged t2t", "t2t.object='job'");
            $select->where("t2t.tag_id IN(?)", array_map("intval", $type));
            $groupResults = true;
        }

        if($exclude_imported) {
            $select->joinLeft("t1.meta t3ei", "t3ei.meta_id = 16");
            $select->where("t3ei.value IS NULL");
        }

        if(!empty($meta)) {
            $meta = apply_filters( "wpjb_jobs_query_meta", $meta );
            
            $job = new Wpjb_Model_Job();
            $m = 1;
            foreach($meta as $k => $v) {
                if(!is_numeric($k)) {
                    $k = $job->meta->$k->id;
                }
                
                $metaObject = new Wpjb_Model_Meta($k);
                $metaType = $metaObject->conf("type");
                $match = "";
                
                // match: all, one-or-more, exact, like
                
                if(in_array($metaType, array("ui-input-text", "ui-input-textarea"))) {
                    $select->join("t1.meta t3m$m");
                    $t1 = Daq_Db::getInstance()->quoteInto("t3m$m.meta_id = ?", $k);
                    $select->where("($t1 AND t3m$m.value LIKE ?)", "%$v%");
                } else {
                    $select->join("t1.meta t3m$m");
                    $t1 = Daq_Db::getInstance()->quoteInto("t3m$m.meta_id = ?", $k);
                    $select->where("($t1 AND t3m$m.value IN(?))", $v);
                }
                    
                $m++;
            }
            $groupResults = true;
        }
		

        if($date_from) {
            $select->where("job_created_at >= ?", $date_from);
        }

        if($date_to) {
            $select->where("job_created_at <= ?", $date_to);
        }
        
        if($expires_from) {
            $select->where("job_expires_at >= ?", $expires_from);
        }

        if($expires_to) {
            $select->where("job_expires_at <= ?", $expires_to);
        }
        
        if(strlen($query)>0 || strlen($location)>0) {
            $select->join("t1.search t4");
        }
        
        if($radius && $location) {
            list($distance, $dunit) = explode(" ", trim($radius));
            $select->having("distance < " . intval($distance));
            $select->order("distance ASC");
            $groupResults = true;
        } elseif($location) {
            $locations = explode(' ', $location);
            foreach($locations as $l) {
                $l = trim($l);
                $l = rtrim($l, ',');
                $select->where("t4.location LIKE ?", "%$l%");
            }
        }
		
		
        if($groupResults) {
            $select->group("t1.id");
        }
        
        //$query = preg_replace( apply_filters( "wpjb_query_allowed_chars", '/[^A-Za-z0-9 ]/' ), "", $query );
        
        $fulltext = "MATCH(t4.title, t4.description, t4.company, t4.location)";
        $fulltext.= "AGAINST (? IN BOOLEAN MODE)";
        
        $q = $fulltext;
        $fulltext = str_replace("?", '\'"'.esc_sql($query).'"\'', $q);
        $itemsFound = 0;
        $t = null;
		
        
        $custom_columns = apply_filters("wpjb_jobs_query_select_columns", "");
        if(is_array($custom_columns)) {
            $custom_columns = join(", ", $custom_columns);
        }
        if(!empty($custom_columns)) {
            $custom_columns = ", ".ltrim($custom_columns, ", ");
        }
        if($radius && $location) {

            list($distance, $dunit) = explode(" ", trim($radius));

            if($dunit == "km") {
                $u = 6371;
            } else {
                $u = 3959;
            }

            $addr = Wpjb_Service_GoogleMaps::locate( apply_filters( "wpjb_narrow_location_search", $location, $params ) );

            $lng = $addr->geo_longitude;
            $lat = $addr->geo_latitude;
            $prefix = $select->getDb()->prefix;

            $qLng = "(SELECT `value` FROM ".$prefix."wpjb_meta_value AS tmp_lng WHERE tmp_lng.object_id=t1.id AND meta_id=6 LIMIT 1)";
            $qLat = "(SELECT `value` FROM ".$prefix."wpjb_meta_value AS tmp_lat WHERE tmp_lat.object_id=t1.id AND meta_id=5 LIMIT 1)";

            $custom_columns .= ", @lng := $qLng AS `lng`, @lat := $qLat AS `lat`, ($u*acos(cos(radians($lat))*cos( radians(@lat))*cos(radians(@lng)-radians($lng))+sin(radians($lat))*sin(radians(@lat)))) AS `distance`";
        }
		
        
        $select->select("COUNT(*) as `cnt`".$custom_columns);
        //$select = apply_filters("wpjb_jobs_query", $select, $params);
        $groupResults = apply_filters( "wpjb_jobs_query_groupresults", $groupResults );
        
        if( $query && mb_strlen( $query ) <= apply_filters( "wpjb_fulltext_min_chars", 3 ) && apply_filters( "wpjb_use_default_query_search", true ) ) {
            $select->where("(t4.title LIKE ?", "%$query%");
            $select->orWhere("t4.description LIKE ?", "%$query%");
            $select->orWhere("t4.company LIKE ?", "%$query%");
            $select->orWhere("t4.location LIKE ?)", "%$query%");
            $itemsFound = self::_found($select, $groupResults);
        } elseif( mb_strlen( $query ) > apply_filters( "wpjb_fulltext_min_chars", 3 )  && apply_filters( "wpjb_use_default_query_search", true ) ) {
            foreach(array(1, 2, 3) as $t) {
                
                $test = clone $select;
                if($t == 1) {
                    $test->where($fulltext);
                } elseif($t == 2) {
                    $modifiers = "+".  str_replace(" ", " +", trim($query));
                    $modifiers = str_replace(array("+-", "++"), array("+", "+"), $query);
                    $test->where($q, $modifiers);
                } else {
                    $test->where($q, $query);
                }

                $itemsFound = self::_found($test, $groupResults);
                if($itemsFound>0) {
                    break;
                }

            }
        } else {
            $itemsFound = self::_found($select, $groupResults);   
        }


        if($t>0) {
            if($t == 1) {
                $select->where($fulltext);
            } elseif($t == 2) {
                $modifiers = "+".  str_replace(" ", " +", $query);
                $modifiers = str_replace(array("+-", "++"), array("+", "+"), $query);
                $test->where($q, $modifiers);
            } else {
                $select->where($q, $query);
            }
        }
        
        if( $groupResults ) {
            $select->group("t1.id");
        }
        
        $select->select("t1.*".$custom_columns);
        
        if($page && $count) {
            $select->limitPage($page, $count);
        }

        if($count_only) {
            return $itemsFound;    
        }
        
//var_dump( $select->toString() );
		
        if($ids_only) {
            $select->select("t1.id".$custom_columns);
            $jobList = $select->getDb()->get_col($select->toString());
        } else {   
            $jobList = $select->execute();
        }
        
        $response = new stdClass;
        $response->job = $jobList;
        $response->page = $page;
        $response->perPage = $count;
        $response->count = count($jobList);
        $response->total = $itemsFound;
        
        if($response->perPage > 0) {
            $response->pages = ceil($response->total/$response->perPage);
        } else {
            $response->pages = 1;
        }
        
        $link = wpjb_api_url("xml/rss");
        $link2 = wpjb_link_to("search");
        $p2 = $params;
        unset($p2["page"]);
        unset($p2["count"]);
        $q2 = http_build_query($p2);
        $glue = "?";
        if(stripos($link, "?")) {
            $glue = "&";
        }
        $response->url = new stdClass;
        $response->url->feed = $link.$glue.$q2;
        $response->url->search = $link2.$glue.$q2;

        
        return $response;
    }
    
    protected function _found($query, $grouped)
    {
        if($grouped || $query->get("having")) {
            return count($query->fetchAll());
        } else {
            return $query->fetchColumn();
        }
    }
           
    /**
     * Displays stats on job details page
     * 
     * This function is called using wpjb_template_job_meta_text filter
     * 
     * @see wpjb_template_job_meta_text filter
     * 
     * @param Daq_Db_OrmAbstract $object
     */
    private function object_stats($id) {

        $metric = apply_filters( "wpjobboard_ga_page_detail_metric", "pageviews" );
        $cache = get_post_meta( $id, "wpjobboard_ga_details", true );
        if( isset( $cache["data"] ) ) {
            $data = $cache["data"];
            return $data["ga:".$metric];
        } else {
            return 0;
        }
    }
    
    public function wpjb_jobs_query_groupresults( $groupResults ) {
        
        if( is_admin() ) {
            return $groupResults;
        }
        
        return true;
    }

    public function wpjb_form_init_alert( $form ) {
        
        if( $form->hasElement( "keyword" ) ) {
            $form->removeElement( "keyword" );
        }
        
        return $form;
    }
    
    public function save_pageviews( $meta_id, $post_id, $meta_key, $meta_value ) {
        
        
        if( $meta_key == "wpjobboard_ga_details" ) {
            
            $data = $meta_value['data'];
            update_post_meta( $post_id, "wpjobboard_lub_pageviews", $data["ga:pageviews"] );
        }
        
    }
    
    public function isNew( $past )
    {
        $now = strtotime(date("Y-m-d H:i:s"));

        $config = (int)Wpjb_Project::getInstance()->conf("front_marked_as_new", 7);
        if( ($now - $past < 24*3600*$config ) && $config != 0 ) {
            return true;
        } else {
            return false;
        }
    }

}